/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.junit.Assert;
import org.junit.Test;

public class SemanticPropUtilTest {
    private final TypeInformation<?> threeIntTupleType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final TypeInformation<?> fourIntTupleType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final TypeInformation<?> fiveIntTupleType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final TypeInformation<?> threeMixedTupleType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
    private final TypeInformation<?> nestedTupleType = new TupleTypeInfo(new TypeInformation[]{this.threeIntTupleType, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final TypeInformation<?> deepNestedTupleType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, this.nestedTupleType, BasicTypeInfo.INT_TYPE_INFO});
    private final TypeInformation<?> pojoType = TypeExtractor.getForClass(TestPojo.class);
    private final TypeInformation<?> pojo2Type = TypeExtractor.getForClass(TestPojo2.class);
    private final TypeInformation<?> nestedPojoType = TypeExtractor.getForClass(NestedTestPojo.class);
    private final TypeInformation<?> pojoInTupleType = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, this.pojoType});
    private final TypeInformation<?> intType = BasicTypeInfo.INT_TYPE_INFO;

    @Test
    public void testSingleProjectionProperties() {
        int[] pMap = new int[]{3, 0, 4};
        SingleInputSemanticProperties sp = SemanticPropUtil.createProjectionPropertiesSingle((int[])pMap, (CompositeType)((CompositeType)this.fiveIntTupleType));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(2)));
        pMap = new int[]{2, 2, 1, 1};
        sp = SemanticPropUtil.createProjectionPropertiesSingle((int[])pMap, (CompositeType)((CompositeType)this.fiveIntTupleType));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 1).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(3)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 2).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(1)));
        pMap = new int[]{2, 0};
        sp = SemanticPropUtil.createProjectionPropertiesSingle((int[])pMap, (CompositeType)((CompositeType)this.nestedTupleType));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(3)));
        pMap = new int[]{2, 0, 1};
        sp = SemanticPropUtil.createProjectionPropertiesSingle((int[])pMap, (CompositeType)((CompositeType)this.deepNestedTupleType));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 6).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(5)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 5).contains(Integer.valueOf(6)));
        pMap = new int[]{2, 1};
        sp = SemanticPropUtil.createProjectionPropertiesSingle((int[])pMap, (CompositeType)((CompositeType)this.pojoInTupleType));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 5).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(4)));
    }

    @Test
    public void testDualProjectionProperties() {
        int[] pMap = new int[]{4, 2, 0, 1, 3, 4};
        boolean[] iMap = new boolean[]{true, true, false, true, false, false};
        DualInputSemanticProperties sp = SemanticPropUtil.createProjectionPropertiesDual((int[])pMap, (boolean[])iMap, this.fiveIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 3).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 4).contains(Integer.valueOf(5)));
        pMap = new int[]{4, 2, 0, 4, 0, 1};
        iMap = new boolean[]{true, true, false, true, false, false};
        sp = SemanticPropUtil.createProjectionPropertiesDual((int[])pMap, (boolean[])iMap, this.fiveIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 4).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(1, 0).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(5)));
        pMap = new int[]{2, 1, 0, 1};
        iMap = new boolean[]{false, false, true, true};
        sp = SemanticPropUtil.createProjectionPropertiesDual((int[])pMap, (boolean[])iMap, this.nestedTupleType, this.threeIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 2).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(5)));
        pMap = new int[]{1, 0, 0};
        iMap = new boolean[]{false, false, true};
        sp = SemanticPropUtil.createProjectionPropertiesDual((int[])pMap, (boolean[])iMap, this.nestedTupleType, this.deepNestedTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 2).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 3).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 4).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 5).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(5)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(6)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(7)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(8)));
        pMap = new int[]{4, 2, 1, 0};
        iMap = new boolean[]{true, false, true, false};
        sp = SemanticPropUtil.createProjectionPropertiesDual((int[])pMap, (boolean[])iMap, this.fiveIntTupleType, this.pojoInTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 2).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 3).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 4).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 5).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(5)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(6)));
        pMap = new int[]{2, 3, -1, 0};
        iMap = new boolean[]{true, true, false, true};
        sp = SemanticPropUtil.createProjectionPropertiesDual((int[])pMap, (boolean[])iMap, this.fiveIntTupleType, this.intType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(3)));
        pMap = new int[]{-1, -1};
        iMap = new boolean[]{false, true};
        sp = SemanticPropUtil.createProjectionPropertiesDual((int[])pMap, (boolean[])iMap, this.intType, this.nestedPojoType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 4).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 5).contains(Integer.valueOf(5)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(6)));
        pMap = new int[]{-1, -1};
        iMap = new boolean[]{true, false};
        sp = SemanticPropUtil.createProjectionPropertiesDual((int[])pMap, (boolean[])iMap, this.intType, this.nestedPojoType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 2).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 3).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 4).contains(Integer.valueOf(5)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(1, 5).contains(Integer.valueOf(6)));
    }

    @Test
    public void testAddSourceFieldOffset() {
        SingleInputSemanticProperties semProps = new SingleInputSemanticProperties();
        semProps.addForwardedField(0, 1);
        semProps.addForwardedField(0, 4);
        semProps.addForwardedField(2, 0);
        semProps.addForwardedField(4, 3);
        semProps.addReadFields(new FieldSet(new int[]{0, 3}));
        SingleInputSemanticProperties offsetProps = SemanticPropUtil.addSourceFieldOffset((SingleInputSemanticProperties)semProps, (int)5, (int)0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 0).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(0, 0).contains(Integer.valueOf(4)));
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 2).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(0, 2).contains(Integer.valueOf(0)));
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 4).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(0, 4).contains(Integer.valueOf(3)));
        Assert.assertTrue((offsetProps.getReadFields(0).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getReadFields(0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)offsetProps.getReadFields(0).contains(Integer.valueOf(3)));
        offsetProps = SemanticPropUtil.addSourceFieldOffset((SingleInputSemanticProperties)semProps, (int)5, (int)3);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 3).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(0, 3).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(0, 3).contains(Integer.valueOf(4)));
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 4).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 5).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(0, 5).contains(Integer.valueOf(0)));
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 6).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 7).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(0, 7).contains(Integer.valueOf(3)));
        Assert.assertTrue((offsetProps.getReadFields(0).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getReadFields(0).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)offsetProps.getReadFields(0).contains(Integer.valueOf(6)));
        semProps = new SingleInputSemanticProperties();
        SemanticPropUtil.addSourceFieldOffset((SingleInputSemanticProperties)semProps, (int)1, (int)0);
        semProps = new SingleInputSemanticProperties();
        semProps.addForwardedField(0, 0);
        semProps.addForwardedField(1, 2);
        semProps.addForwardedField(2, 4);
        offsetProps = SemanticPropUtil.addSourceFieldOffset((SingleInputSemanticProperties)semProps, (int)3, (int)2);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 2).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(0, 2).contains(Integer.valueOf(0)));
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 3).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(0, 3).contains(Integer.valueOf(2)));
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 4).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(0, 4).contains(Integer.valueOf(4)));
    }

    @Test
    public void testAddSourceFieldOffsets() {
        DualInputSemanticProperties semProps = new DualInputSemanticProperties();
        semProps.addForwardedField(0, 0, 1);
        semProps.addForwardedField(0, 3, 3);
        semProps.addForwardedField(1, 1, 2);
        semProps.addForwardedField(1, 1, 4);
        semProps.addReadFields(0, new FieldSet(new int[]{1, 2}));
        semProps.addReadFields(1, new FieldSet(new int[]{0, 3, 4}));
        DualInputSemanticProperties offsetProps = SemanticPropUtil.addSourceFieldOffsets((DualInputSemanticProperties)semProps, (int)4, (int)3, (int)1, (int)2);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 1).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(0, 4).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(0, 4).contains(Integer.valueOf(3)));
        Assert.assertTrue((offsetProps.getForwardingTargetFields(1, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(1, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(1, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((offsetProps.getForwardingTargetFields(1, 3).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(1, 3).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)offsetProps.getForwardingTargetFields(1, 3).contains(Integer.valueOf(4)));
        Assert.assertTrue((offsetProps.getReadFields(0).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getReadFields(0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)offsetProps.getReadFields(0).contains(Integer.valueOf(3)));
        Assert.assertTrue((offsetProps.getReadFields(1).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)offsetProps.getReadFields(1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)offsetProps.getReadFields(1).contains(Integer.valueOf(5)));
        Assert.assertTrue((boolean)offsetProps.getReadFields(1).contains(Integer.valueOf(6)));
        semProps = new DualInputSemanticProperties();
        SemanticPropUtil.addSourceFieldOffsets((DualInputSemanticProperties)semProps, (int)4, (int)3, (int)2, (int)2);
    }

    @Test
    public void testForwardedNoArrowIndividualStrings() {
        String[] forwardedFields = new String[]{"f2", "f3", "f0"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.fiveIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
    }

    @Test
    public void testForwardedNoArrowOneString() {
        String[] forwardedFields = new String[]{"f2;f3;f0"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.fiveIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        forwardedFields[0] = "2;3;0";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.fiveIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        forwardedFields[0] = "2;3;0;";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.fiveIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
    }

    @Test
    public void testForwardedNoArrowSpaces() {
        String[] forwardedFields = new String[]{"  f2  ;   f3  ;  f0   "};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.fiveIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
    }

    @Test
    public void testForwardedWithArrowIndividualStrings() {
        String[] forwardedFields = new String[]{"f0->f1", "f1->f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.threeIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
    }

    @Test
    public void testForwardedWithArrowOneString() {
        String[] forwardedFields = new String[]{"f0->f0;f1->f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.threeIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        forwardedFields[0] = "0->0;1->2";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.threeIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
    }

    @Test
    public void testForwardedWithArrowSpaces() {
        String[] forwardedFields = new String[]{"  f0 ->  f0    ;   f1  -> f2 "};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.threeIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
    }

    @Test
    public void testForwardedMixedOneString() {
        String[] forwardedFields = new String[]{"f2;f3;f0->f4;f4->f0"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.fiveIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(0)));
    }

    @Test
    public void testForwardedBasicType() {
        String[] forwardedFields = new String[]{"f1->*"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.threeIntTupleType, this.intType);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(0)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        forwardedFields[0] = "*->f2";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.intType, this.threeIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(2)));
        forwardedFields[0] = "*->*";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.intType, this.intType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
    }

    @Test
    public void testForwardedWildCard() {
        String[] forwardedFields = new String[]{"*"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.threeIntTupleType, this.threeIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        forwardedFields[0] = "*";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.deepNestedTupleType, this.deepNestedTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(4)));
    }

    @Test
    public void testForwardedNestedTuples() {
        String[] forwardedFields = new String[]{"f0->f0.f0; f1->f0.f1; f2->f0.f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.threeIntTupleType, this.nestedTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        forwardedFields[0] = "f0.f0->f1.f0.f2; f0.f1->f2; f2->f1.f2; f1->f0";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.nestedTupleType, this.deepNestedTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(6)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(5)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(0)));
        forwardedFields[0] = "0.0->1.0.2; 0.1->2; 2->1.2; 1->0";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.nestedTupleType, this.deepNestedTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(6)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(5)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(0)));
        forwardedFields[0] = "f1.f0.*->f0.*; f0->f2";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.deepNestedTupleType, this.nestedTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(4)));
        forwardedFields[0] = "1.0.*->0.*; 0->2";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.deepNestedTupleType, this.nestedTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(4)));
        forwardedFields[0] = "f1.f0->f0; f0->f2";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.deepNestedTupleType, this.nestedTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(4)));
        forwardedFields[0] = "1.0->0; 0->2";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.deepNestedTupleType, this.nestedTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(4)));
        forwardedFields[0] = "f1.f0.f1; f1.f1; f2";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.deepNestedTupleType, this.deepNestedTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 6).contains(Integer.valueOf(6)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
        forwardedFields[0] = "f1.f0.*; f1.f2";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.deepNestedTupleType, this.deepNestedTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 5).contains(Integer.valueOf(5)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 4).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 6).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testForwardedPojo() {
        String[] forwardedFields = new String[]{"int1->int2; int3->int1; string1 "};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.pojoType, this.pojoType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        forwardedFields[0] = "f1->int1; f0->int3 ";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.threeIntTupleType, this.pojoType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(0)));
        forwardedFields[0] = "int1->f2; int2->f0; int3->f1";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.pojoType, this.threeIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(1)));
        forwardedFields[0] = "*->pojo1.*";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.pojoType, this.nestedPojoType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(4)));
        forwardedFields[0] = "*->pojo1";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.pojoType, this.nestedPojoType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(4)));
        forwardedFields[0] = "int1; string1; int2->pojo1.int3";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.pojoType, this.nestedPojoType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(3)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(5)));
        forwardedFields[0] = "pojo1.*->f2.*; int1->f1";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.nestedPojoType, this.pojoInTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(5)));
        forwardedFields[0] = "f2.*->*";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.pojoInTupleType, this.pojoType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 5).contains(Integer.valueOf(3)));
        forwardedFields[0] = "pojo1->f2; int1->f1";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.nestedPojoType, this.pojoInTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(5)));
        forwardedFields[0] = "f2->*";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.pojoInTupleType, this.pojoType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 5).contains(Integer.valueOf(3)));
        forwardedFields[0] = "int2; string1";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.pojoType, this.pojoType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        forwardedFields[0] = "pojo1.int1; string1";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.nestedPojoType, this.nestedPojoType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 5).contains(Integer.valueOf(5)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 4).size() == 0 ? 1 : 0) != 0);
        forwardedFields[0] = "pojo1.*; int1";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.nestedPojoType, this.nestedPojoType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(4)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
        forwardedFields[0] = "pojo1; int1";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.nestedPojoType, this.nestedPojoType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(4)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testInvalidPojoField() {
        String[] forwardedFields = new String[]{"invalidField"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.pojoType, this.threeIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedNoArrowOneStringInvalidDelimiter() {
        String[] forwardedFields = new String[]{"f2,f3,f0"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.fiveIntTupleType, this.fiveIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedSameTargetTwice() {
        String[] forwardedFields = new String[]{"f0->f2; f1->f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.fiveIntTupleType, this.fiveIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedInvalidTargetFieldType1() {
        String[] forwardedFields = new String[]{"f0->f0", "f1->f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.fiveIntTupleType, this.threeMixedTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedInvalidTargetFieldType2() {
        String[] forwardedFields = new String[]{"f2.*->*"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.pojoInTupleType, this.pojo2Type);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedInvalidTargetFieldType3() {
        String[] forwardedFields = new String[]{"*"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.pojoInTupleType, this.pojo2Type);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedInvalidTargetFieldType4() {
        String[] forwardedFields = new String[]{"int1; string1"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.pojoInTupleType, this.pojo2Type);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedInvalidTargetFieldType5() {
        String[] forwardedFields = new String[]{"f0.*->*"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.nestedTupleType, this.fiveIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedWildCardInvalidTypes1() {
        String[] forwardedFields = new String[]{"*"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.fiveIntTupleType, this.threeIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedWildCardInvalidTypes2() {
        String[] forwardedFields = new String[]{"*"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.threeIntTupleType, this.fiveIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedWildCardInvalidTypes3() {
        String[] forwardedFields = new String[]{"*"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.pojoType, this.pojo2Type);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedForwardWildCard() {
        String[] forwardedFields = new String[]{"f1->*"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.threeIntTupleType, this.threeIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedInvalidExpression() {
        String[] forwardedFields = new String[]{"f0"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.intType, this.threeIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedForwardMultiFields() {
        String[] forwardedFields = new String[]{"f1->f0,f1"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.threeIntTupleType, this.threeIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedInvalidString() {
        String[] forwardedFields = new String[]{"notValid"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, null, this.threeIntTupleType, this.threeIntTupleType);
    }

    @Test
    public void testNonForwardedIndividualStrings() {
        String[] nonForwardedFields = new String[]{"f1", "f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.threeIntTupleType, this.threeIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNonForwardedSingleString() {
        String[] nonForwardedFields = new String[]{"f1;f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.threeIntTupleType, this.threeIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        nonForwardedFields[0] = "f1;f2;";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.threeIntTupleType, this.threeIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNonForwardedSpaces() {
        String[] nonForwardedFields = new String[]{" f1 ;   f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.threeIntTupleType, this.threeIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNonForwardedNone() {
        String[] nonForwardedFields = new String[]{""};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.threeIntTupleType, this.threeIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
    }

    @Test
    public void testNonForwardedNestedTuple() {
        String[] nonForwardedFields = new String[]{"f1.f0.*; f1.f2; f0"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.deepNestedTupleType, this.deepNestedTupleType);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(4)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 6).contains(Integer.valueOf(6)));
        nonForwardedFields[0] = "f1.f0; f1.f2; f0";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.deepNestedTupleType, this.deepNestedTupleType);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(4)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 6).contains(Integer.valueOf(6)));
        nonForwardedFields[0] = "f2; f1.f1";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.deepNestedTupleType, this.deepNestedTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 4).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 5).contains(Integer.valueOf(5)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 6).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNonForwardedPojo() {
        String[] nonForwardedFields = new String[]{"int1; string1"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.pojoType, this.pojoType);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNonForwardedNestedPojo() {
        String[] nonForwardedFields = new String[]{"int1; pojo1.*"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.nestedPojoType, this.nestedPojoType);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 4).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 5).contains(Integer.valueOf(5)));
        nonForwardedFields[0] = "pojo1.int2; string1";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.nestedPojoType, this.nestedPojoType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(4)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testNonForwardedInvalidTypes1() {
        String[] nonForwardedFields = new String[]{"f1; f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.threeIntTupleType, this.nestedPojoType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testNonForwardedInvalidTypes2() {
        String[] nonForwardedFields = new String[]{"f1; f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.nestedPojoType, this.threeIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testNonForwardedInvalidTypes3() {
        String[] nonForwardedFields = new String[]{"f1; f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.threeIntTupleType, this.fiveIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testNonForwardedInvalidTypes4() {
        String[] nonForwardedFields = new String[]{"f1; f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.fiveIntTupleType, this.threeIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testNonForwardedInvalidTypes5() {
        String[] nonForwardedFields = new String[]{"int1"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.pojoType, this.pojo2Type);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testNonForwardedInvalidNesting() {
        String[] nonForwardedFields = new String[]{"f0.f4"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.nestedTupleType, this.nestedTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testNonForwardedInvalidString() {
        String[] nonForwardedFields = new String[]{"notValid"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, null, this.threeIntTupleType, this.threeIntTupleType);
    }

    @Test
    public void testReadFieldsIndividualStrings() {
        String[] readFields = new String[]{"f1", "f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.threeIntTupleType, this.threeIntTupleType);
        FieldSet fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
    }

    @Test
    public void testReadFieldsOneString() {
        String[] readFields = new String[]{"f1;f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.threeIntTupleType, this.threeIntTupleType);
        FieldSet fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        readFields[0] = "f1;f2;";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.threeIntTupleType, this.threeIntTupleType);
        fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
    }

    @Test
    public void testReadFieldsSpaces() {
        String[] readFields = new String[]{"  f1  ; f2   "};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.threeIntTupleType, this.threeIntTupleType);
        FieldSet fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
    }

    @Test
    public void testReadFieldsBasic() {
        String[] readFields = new String[]{"*"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.intType, this.intType);
        FieldSet fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.intType, this.fiveIntTupleType);
        fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
    }

    @Test
    public void testReadFieldsNestedTuples() {
        String[] readFields = new String[]{"f0.f1; f0.f2; f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.nestedTupleType, this.intType);
        FieldSet fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(4)));
        readFields[0] = "f0;f1";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.nestedTupleType, this.intType);
        fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
    }

    @Test
    public void testReadFieldsNestedTupleWildCard() {
        String[] readFields = new String[]{"*"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.nestedTupleType, this.intType);
        FieldSet fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(4)));
        readFields[0] = "f0.*;f1";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.nestedTupleType, this.intType);
        fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
    }

    @Test
    public void testReadFieldsPojo() {
        String[] readFields = new String[]{"int2; string1"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.pojoType, this.threeIntTupleType);
        FieldSet fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
        readFields[0] = "*";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.pojoType, this.intType);
        fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
    }

    @Test
    public void testReadFieldsNestedPojo() {
        String[] readFields = new String[]{"pojo1.int2; string1; pojo1.string1"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.nestedPojoType, this.intType);
        FieldSet fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(5)));
        readFields[0] = "pojo1.*";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.nestedPojoType, this.intType);
        fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(4)));
        readFields[0] = "pojo1";
        sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.nestedPojoType, this.intType);
        fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(4)));
    }

    @Test
    public void testReadFieldsPojoInTuple() {
        String[] readFields = new String[]{"f0; f2.int1; f2.string1"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.pojoInTupleType, this.pojo2Type);
        FieldSet fs = sp.getReadFields(0);
        Assert.assertTrue((fs.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)fs.contains(Integer.valueOf(5)));
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testReadFieldsInvalidString() {
        String[] readFields = new String[]{"notValid"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, null, (String[])readFields, this.threeIntTupleType, this.threeIntTupleType);
    }

    @Test
    public void testForwardedDual() {
        String[] forwardedFieldsFirst = new String[]{"f1->f2; f2->f3"};
        String[] forwardedFieldsSecond = new String[]{"f1->f1; f2->f0"};
        DualInputSemanticProperties dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, (String[])forwardedFieldsFirst, (String[])forwardedFieldsSecond, null, null, null, null, this.fourIntTupleType, this.fourIntTupleType, this.fourIntTupleType);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 2).contains(Integer.valueOf(0)));
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(1, 3).size() == 0 ? 1 : 0) != 0);
        forwardedFieldsFirst[0] = "f1->f0;f3->f1";
        forwardedFieldsSecond[0] = "*->f2.*";
        dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, (String[])forwardedFieldsFirst, (String[])forwardedFieldsSecond, null, null, null, null, this.fourIntTupleType, this.pojoType, this.pojoInTupleType);
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(0)));
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 2).contains(Integer.valueOf(4)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 3).contains(Integer.valueOf(5)));
        forwardedFieldsFirst[0] = "f1.f0.f2->int1; f2->pojo1.int3";
        forwardedFieldsSecond[0] = "string1; int2->pojo1.int1; int1->pojo1.int2";
        dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, (String[])forwardedFieldsFirst, (String[])forwardedFieldsSecond, null, null, null, null, this.deepNestedTupleType, this.pojoType, this.nestedPojoType);
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(0)));
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 4).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 6).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((dsp.getForwardingTargetFields(1, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 3).contains(Integer.valueOf(5)));
        String[] forwardedFieldsFirst2 = new String[]{"f1.f0.f2->int1", "f2->pojo1.int3"};
        String[] forwardedFieldsSecond2 = new String[]{"string1", "int2->pojo1.int1", "int1->pojo1.int2"};
        dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, (String[])forwardedFieldsFirst2, (String[])forwardedFieldsSecond2, null, null, null, null, this.deepNestedTupleType, this.pojoType, this.nestedPojoType);
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 3).contains(Integer.valueOf(0)));
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 4).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 5).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 6).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((dsp.getForwardingTargetFields(1, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 3).contains(Integer.valueOf(5)));
    }

    @Test
    public void testNonForwardedDual() {
        String[] nonForwardedFieldsFirst = new String[]{"f1;f2"};
        String[] nonForwardedFieldsSecond = new String[]{"f0"};
        DualInputSemanticProperties dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, null, null, (String[])nonForwardedFieldsFirst, (String[])nonForwardedFieldsSecond, null, null, this.threeIntTupleType, this.threeIntTupleType, this.threeIntTupleType);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(1, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 2).contains(Integer.valueOf(2)));
        nonForwardedFieldsFirst[0] = "f1";
        nonForwardedFieldsSecond[0] = "";
        dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, null, null, (String[])nonForwardedFieldsFirst, null, null, null, this.threeIntTupleType, this.fiveIntTupleType, this.threeIntTupleType);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((dsp.getForwardingTargetFields(1, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(1, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(1, 2).size() == 0 ? 1 : 0) != 0);
        nonForwardedFieldsFirst[0] = "";
        nonForwardedFieldsSecond[0] = "f2;f0";
        dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, null, null, null, (String[])nonForwardedFieldsSecond, null, null, this.fiveIntTupleType, this.threeIntTupleType, this.threeIntTupleType);
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(1, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((dsp.getForwardingTargetFields(1, 2).size() == 0 ? 1 : 0) != 0);
        String[] nonForwardedFields = new String[]{"f1", "f3"};
        dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, null, null, (String[])nonForwardedFields, null, null, null, this.fiveIntTupleType, this.threeIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 4).contains(Integer.valueOf(4)));
        dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, null, null, null, (String[])nonForwardedFields, null, null, this.threeIntTupleType, this.fiveIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((dsp.getForwardingTargetFields(1, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 2).contains(Integer.valueOf(2)));
        Assert.assertTrue((dsp.getForwardingTargetFields(1, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 4).contains(Integer.valueOf(4)));
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testNonForwardedDualInvalidTypes1() {
        String[] nonForwardedFieldsFirst = new String[]{"f1"};
        DualInputSemanticProperties dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, null, null, (String[])nonForwardedFieldsFirst, null, null, null, this.fiveIntTupleType, this.threeIntTupleType, this.threeIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testNonForwardedDualInvalidTypes2() {
        String[] nonForwardedFieldsSecond = new String[]{"f1"};
        DualInputSemanticProperties dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, null, null, null, (String[])nonForwardedFieldsSecond, null, null, this.threeIntTupleType, this.pojoInTupleType, this.threeIntTupleType);
    }

    @Test
    public void testReadFieldsDual() {
        String[] readFieldsFirst = new String[]{"f1;f2"};
        String[] readFieldsSecond = new String[]{"f0"};
        DualInputSemanticProperties dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, null, null, null, null, (String[])readFieldsFirst, (String[])readFieldsSecond, this.threeIntTupleType, this.threeIntTupleType, this.threeIntTupleType);
        Assert.assertTrue((dsp.getReadFields(0).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getReadFields(0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)dsp.getReadFields(0).contains(Integer.valueOf(2)));
        Assert.assertTrue((dsp.getReadFields(1).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getReadFields(1).contains(Integer.valueOf(0)));
        readFieldsFirst[0] = "f0.*; f2";
        readFieldsSecond[0] = "int1; string1";
        dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, null, null, null, null, (String[])readFieldsFirst, (String[])readFieldsSecond, this.nestedTupleType, this.pojoType, this.threeIntTupleType);
        Assert.assertTrue((dsp.getReadFields(0).size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getReadFields(0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)dsp.getReadFields(0).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)dsp.getReadFields(0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)dsp.getReadFields(0).contains(Integer.valueOf(4)));
        Assert.assertTrue((dsp.getReadFields(1).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getReadFields(1).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)dsp.getReadFields(1).contains(Integer.valueOf(3)));
        readFieldsFirst[0] = "pojo1.int2; string1";
        readFieldsSecond[0] = "f2.int2";
        dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, null, null, null, null, (String[])readFieldsFirst, (String[])readFieldsSecond, this.nestedPojoType, this.pojoInTupleType, this.threeIntTupleType);
        Assert.assertTrue((dsp.getReadFields(0).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getReadFields(0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)dsp.getReadFields(0).contains(Integer.valueOf(5)));
        Assert.assertTrue((dsp.getReadFields(1).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getReadFields(1).contains(Integer.valueOf(3)));
        String[] readFields = new String[]{"f0", "f2", "f4"};
        dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, null, null, null, null, (String[])readFields, (String[])readFields, this.fiveIntTupleType, this.fiveIntTupleType, this.threeIntTupleType);
        Assert.assertTrue((dsp.getReadFields(0).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getReadFields(0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)dsp.getReadFields(0).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)dsp.getReadFields(0).contains(Integer.valueOf(4)));
        Assert.assertTrue((dsp.getReadFields(1).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getReadFields(1).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)dsp.getReadFields(1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)dsp.getReadFields(1).contains(Integer.valueOf(4)));
    }

    @Test
    public void testForwardedRead() {
        String[] forwardedFields = new String[]{"f0->f0;f1->f2"};
        String[] readFields = new String[]{"f0; f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, (String[])forwardedFields, null, (String[])readFields, this.threeIntTupleType, this.fiveIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((sp.getReadFields(0).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getReadFields(0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getReadFields(0).contains(Integer.valueOf(2)));
    }

    @Test
    public void testNonForwardedRead() {
        String[] nonForwardedFields = new String[]{"f1;f2"};
        String[] readFields = new String[]{"f0; f2"};
        SingleInputSemanticProperties sp = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, null, (String[])nonForwardedFields, (String[])readFields, this.threeIntTupleType, this.threeIntTupleType);
        Assert.assertTrue((boolean)sp.getForwardingTargetFields(0, 0).contains(Integer.valueOf(0)));
        Assert.assertTrue((sp.getForwardingTargetFields(0, 1).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getForwardingTargetFields(0, 2).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getReadFields(0).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sp.getReadFields(0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)sp.getReadFields(0).contains(Integer.valueOf(2)));
    }

    @Test
    public void testForwardedReadDual() {
        String[] forwardedFieldsFirst = new String[]{"f1->f2; f2->f3"};
        String[] forwardedFieldsSecond = new String[]{"f1->f1; f2->f0"};
        String[] readFieldsFirst = new String[]{"0;2"};
        String[] readFieldsSecond = new String[]{"1"};
        DualInputSemanticProperties dsp = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dsp, (String[])forwardedFieldsFirst, (String[])forwardedFieldsSecond, null, null, (String[])readFieldsFirst, (String[])readFieldsSecond, this.fourIntTupleType, this.fourIntTupleType, this.fourIntTupleType);
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 1).contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(0, 2).contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 1).contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)dsp.getForwardingTargetFields(1, 2).contains(Integer.valueOf(0)));
        Assert.assertTrue((dsp.getForwardingTargetFields(0, 0).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getForwardingTargetFields(1, 3).size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dsp.getReadFields(0).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getReadFields(0).contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)dsp.getReadFields(0).contains(Integer.valueOf(2)));
        Assert.assertTrue((dsp.getReadFields(1).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dsp.getReadFields(1).contains(Integer.valueOf(1)));
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedNonForwardedCheck() {
        String[] forwarded = new String[]{"1"};
        String[] nonForwarded = new String[]{"1"};
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)new SingleInputSemanticProperties(), (String[])forwarded, (String[])nonForwarded, null, this.threeIntTupleType, this.threeIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedNonForwardedFirstCheck() {
        String[] forwarded = new String[]{"1"};
        String[] nonForwarded = new String[]{"1"};
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)new DualInputSemanticProperties(), (String[])forwarded, null, (String[])nonForwarded, null, null, null, this.threeIntTupleType, this.threeIntTupleType, this.threeIntTupleType);
    }

    @Test(expected=SemanticProperties.InvalidSemanticAnnotationException.class)
    public void testForwardedNonForwardedSecondCheck() {
        String[] forwarded = new String[]{"1"};
        String[] nonForwarded = new String[]{"1"};
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)new DualInputSemanticProperties(), null, (String[])forwarded, null, (String[])nonForwarded, null, null, this.threeIntTupleType, this.threeIntTupleType, this.threeIntTupleType);
    }

    public static class NestedTestPojo {
        public int int1;
        public TestPojo pojo1;
        public String string1;
    }

    public static class TestPojo2 {
        public int myInt1;
        public int myInt2;
        public int myInt3;
        public String myString1;
    }

    public static class TestPojo {
        public int int1;
        public int int2;
        public int int3;
        public String string1;
    }
}

