/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.utils;

import android.util.Log;
import com.tencent.cos.xml.CosXmlBaseService;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.utils.CloseUtil;
import com.tencent.qcloud.core.util.OkhttpInternalUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveInputStreamToTmpFile(InputStream stream, File file, long offset, long size) throws IOException {
        FileOutputStream fos = null;
        try {
            int bytesRead;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            long bytesTotal = 0L;
            long bytesLimit = size;
            if (bytesLimit < 0L) {
                bytesLimit = Long.MAX_VALUE;
            }
            if (offset > 0L) {
                long l = stream.skip(offset);
            }
            while (bytesTotal < bytesLimit && (bytesRead = stream.read(buffer)) != -1) {
                fos.write(buffer, 0, (int)Math.min((long)bytesRead, bytesLimit - bytesTotal));
                bytesTotal += (long)bytesRead;
            }
            fos.flush();
        }
        finally {
            if (fos != null) {
                OkhttpInternalUtils.closeQuietly((Closeable)fos);
            }
        }
    }

    public static String tempCache(InputStream inputStream) throws CosXmlClientException {
        String string;
        if (inputStream == null) {
            return null;
        }
        FileOutputStream fileOutputStream = null;
        try {
            String tempPath = CosXmlBaseService.appCachePath + File.separator + "temp.tmp";
            Log.d((String)"UnitTest", (String)tempPath);
            File tempFile = new File(tempPath);
            if (tempFile.exists()) {
                tempFile.delete();
            }
            fileOutputStream = new FileOutputStream(tempFile);
            byte[] buffer = new byte[65536];
            int receiveLen = -1;
            while ((receiveLen = inputStream.read(buffer, 0, buffer.length)) > 0) {
                fileOutputStream.write(buffer, 0, receiveLen);
            }
            fileOutputStream.flush();
            string = tempPath;
        }
        catch (IOException e) {
            try {
                throw new CosXmlClientException(ClientErrorCode.IO_ERROR.getCode(), e);
            }
            catch (Throwable throwable) {
                CloseUtil.closeQuietly(fileOutputStream);
                CloseUtil.closeQuietly(inputStream);
                throw throwable;
            }
        }
        CloseUtil.closeQuietly(fileOutputStream);
        CloseUtil.closeQuietly(inputStream);
        return string;
    }

    public static void intercept(String filePath, long offset, long size) throws IOException {
        long skip;
        if (size <= 0L) {
            FileUtils.clearFile(filePath);
        }
        File sourceFile = new File(filePath);
        File tempFile = new File(filePath.concat("." + System.currentTimeMillis() + ".temp"));
        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
        FileInputStream fileInputStream = new FileInputStream(sourceFile);
        if (offset > 0L && (skip = fileInputStream.skip(offset)) != offset) {
            throw new IOException("skip size is not equal to offset");
        }
        long remainSize = size;
        byte[] buffer = new byte[65536];
        int pageLength = (int)Math.min((long)buffer.length, remainSize);
        int readLength = 0;
        while ((readLength = fileInputStream.read(buffer, 0, pageLength)) > 0) {
            fileOutputStream.write(buffer, 0, readLength);
            pageLength = (int)Math.min((long)buffer.length, remainSize -= (long)readLength);
        }
        FileUtils.deleteFileIfExist(filePath);
        boolean rename = tempFile.renameTo(sourceFile);
        if (!rename) {
            throw new IOException("rename to " + filePath + "failed");
        }
    }

    public static boolean deleteFileIfExist(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static boolean clearFile(String filePath) throws IOException {
        if (FileUtils.deleteFileIfExist(filePath)) {
            return new File(filePath).createNewFile();
        }
        return false;
    }

    public static File[] listFile(File file) {
        if (file != null && file.isDirectory()) {
            return file.listFiles();
        }
        return null;
    }
}

