/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.tencent.cos.xml.BeaconService;
import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.transfer.COSXMLTask;
import com.tencent.cos.xml.transfer.COSXMLUploadTask;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.cos.xml.utils.COSUtils;
import com.tencent.cos.xml.utils.DigestUtils;
import com.tencent.cos.xml.utils.FileUtils;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.common.QCloudTaskStateListener;
import com.tencent.qcloud.core.logger.QCloudLogger;
import java.io.File;
import java.util.List;
import java.util.Map;

public final class COSXMLDownloadTask
extends COSXMLTask {
    private static final String TAG = COSXMLUploadTask.class.getSimpleName();
    private String localSaveDirPath;
    private String localSaveFileName;
    private long rangeStart = 0L;
    private long rangeEnd = -1L;
    private long fileOffset = 0L;
    private String eTag;
    private long hasWriteDataLen = 0L;
    private long startTime = 0L;
    private HeadObjectRequest headObjectRequest;
    private GetObjectRequest getObjectRequest;
    private SharedPreferences sharedPreferences;

    COSXMLDownloadTask(Context context, CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, String localSaveDirPath, String localSaveFileName) {
        this.region = region;
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.localSaveDirPath = localSaveDirPath;
        this.localSaveFileName = localSaveFileName;
        this.cosXmlService = cosXmlService;
        if (context != null) {
            this.sharedPreferences = context.getSharedPreferences("COSXMLDOWNLOADTASK", 0);
        }
    }

    COSXMLDownloadTask(Context context, CosXmlSimpleService cosXmlService, GetObjectRequest getObjectRequest) {
        this(context, cosXmlService, getObjectRequest.getRegion(), getObjectRequest.getBucket(), getObjectRequest.getPath(cosXmlService.getConfig()), getObjectRequest.getSavePath(), getObjectRequest.getSaveFileName());
        this.queries = getObjectRequest.getQueryString();
        this.headers = getObjectRequest.getRequestHeaders();
        this.isNeedMd5 = getObjectRequest.isNeedMD5();
        if (this.headers != null && this.headers.containsKey("Range")) {
            List ranges = (List)this.headers.get("Range");
            String range = (String)ranges.get(0);
            int index1 = range.indexOf("=");
            int index2 = range.indexOf("-");
            this.rangeStart = Long.valueOf(range.substring(index1 + 1, index2));
            String end = range.substring(index2 + 1);
            if (!TextUtils.isEmpty((CharSequence)end)) {
                this.rangeEnd = Long.valueOf(end);
            }
        }
        this.fileOffset = getObjectRequest.getFileOffset();
    }

    protected void download() {
        this.startTime = System.nanoTime();
        this.run();
    }

    private void realDownload(long rangeStart, long rangeEnd, long fileOffset) {
        this.getObjectRequest = new GetObjectRequest(this.bucket, this.cosPath, this.localSaveDirPath, this.localSaveFileName);
        this.getObjectRequest.setRegion(this.region);
        this.getObjectRequest.setFileOffset(fileOffset);
        this.getObjectRequest.setQueryParameters(this.queries);
        this.getObjectRequest.setRequestHeaders(this.headers);
        if (rangeEnd > 0L || rangeStart > 0L) {
            this.getObjectRequest.setRange(rangeStart, rangeEnd);
            this.getObjectRequest.addNoSignHeader("Range");
        }
        if (this.onSignatureListener != null) {
            this.getObjectRequest.setSign(this.onSignatureListener.onGetSign((CosXmlRequest)this.getObjectRequest));
        }
        this.getHttpMetrics((CosXmlRequest)this.getObjectRequest, "GetObjectRequest");
        this.getObjectRequest.setProgressListener(new CosXmlProgressListener(){

            public void onProgress(long complete, long target) {
                if (COSXMLDownloadTask.this.cosXmlProgressListener != null) {
                    COSXMLDownloadTask.this.cosXmlProgressListener.onProgress(COSXMLDownloadTask.this.hasWriteDataLen + complete, COSXMLDownloadTask.this.hasWriteDataLen + target);
                }
            }
        });
        this.cosXmlService.getObjectAsync(this.getObjectRequest, new CosXmlResultListener(){

            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (request != COSXMLDownloadTask.this.getObjectRequest) {
                    return;
                }
                BeaconService.getInstance().reportDownloadTaskSuccess((CosXmlRequest)COSXMLDownloadTask.this.getObjectRequest);
                if (COSXMLDownloadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLDownloadTask.this.IS_EXIT.set(true);
                COSXMLDownloadTask.this.updateState(TransferState.COMPLETED, null, result, false);
            }

            public void onFail(CosXmlRequest request, CosXmlClientException clientException, CosXmlServiceException serviceException) {
                if (request != COSXMLDownloadTask.this.getObjectRequest) {
                    return;
                }
                Throwable causeException = null;
                if (clientException != null && COSXMLDownloadTask.this.taskState != TransferState.PAUSED && COSXMLDownloadTask.this.taskState != TransferState.CANCELED) {
                    BeaconService.getInstance().reportDownloadTaskClientException(request, (QCloudClientException)((Object)clientException));
                    causeException = clientException;
                }
                if (serviceException != null && COSXMLDownloadTask.this.taskState != TransferState.PAUSED && COSXMLDownloadTask.this.taskState != TransferState.CANCELED) {
                    BeaconService.getInstance().reportDownloadTaskServiceException(request, (QCloudServiceException)serviceException);
                    causeException = serviceException;
                }
                if (COSXMLDownloadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLDownloadTask.this.IS_EXIT.set(true);
                COSXMLDownloadTask.this.updateState(TransferState.FAILED, (Exception)causeException, null, false);
            }
        });
    }

    @Override
    protected CosXmlRequest buildCOSXMLTaskRequest() {
        COSXMLDownloadTaskRequest cosxmlDownloadTaskRequest = new COSXMLDownloadTaskRequest(this.region, this.bucket, this.cosPath, this.localSaveDirPath, this.localSaveFileName, this.headers, this.queries);
        return cosxmlDownloadTaskRequest;
    }

    @Override
    protected CosXmlResult buildCOSXMLTaskResult(CosXmlResult sourceResult) {
        COSXMLDownloadTaskResult cosxmlDownloadTaskResult = new COSXMLDownloadTaskResult();
        if (sourceResult != null) {
            cosxmlDownloadTaskResult.httpCode = sourceResult.httpCode;
            cosxmlDownloadTaskResult.httpMessage = sourceResult.httpMessage;
            cosxmlDownloadTaskResult.headers = sourceResult.headers;
            cosxmlDownloadTaskResult.eTag = this.eTag;
            cosxmlDownloadTaskResult.accessUrl = sourceResult.accessUrl;
        }
        return cosxmlDownloadTaskResult;
    }

    private String getKey() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("download").append("_").append(this.region).append("_").append(this.bucket).append("_").append(this.cosPath).append("_").append(this.rangeStart).append("_").append(this.rangeEnd).append("_").append(this.fileOffset).append("_").append(this.localSaveDirPath).append("_").append(this.localSaveFileName).append("_").append(this.eTag);
        try {
            return DigestUtils.getSha1((String)stringBuffer.toString());
        }
        catch (CosXmlClientException e2) {
            return stringBuffer.toString();
        }
    }

    private synchronized String hasExisted() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(this.getKey(), null);
        }
        return null;
    }

    private synchronized void clear() {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().remove(this.getKey()).commit();
        }
    }

    private void cancelAllRequest(boolean now) {
        HeadObjectRequest tempHeadObjectRequest = this.headObjectRequest;
        this.cosXmlService.cancel((CosXmlRequest)tempHeadObjectRequest, now);
        GetObjectRequest tempGetObjectRequest = this.getObjectRequest;
        this.cosXmlService.cancel((CosXmlRequest)tempGetObjectRequest, now);
    }

    private synchronized void save(String absolutePath) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(this.getKey(), absolutePath).commit();
        }
    }

    private String getDownloadPath() {
        String path = null;
        if (this.localSaveDirPath != null) {
            path = !this.localSaveDirPath.endsWith("/") ? this.localSaveDirPath + "/" : this.localSaveDirPath;
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (this.localSaveFileName != null) {
                path = path + this.localSaveFileName;
                return path;
            }
            if (this.cosPath != null) {
                int separator = this.cosPath.lastIndexOf("/");
                path = separator >= 0 ? path + this.cosPath.substring(separator + 1) : path + this.cosPath;
            }
        }
        return path;
    }

    protected void run() {
        this.headObjectRequest = new HeadObjectRequest(this.bucket, this.cosPath);
        this.headObjectRequest.setRequestHeaders(this.headers);
        this.headObjectRequest.setQueryParameters(this.queries);
        this.headObjectRequest.setRegion(this.region);
        final String downloadPath = this.getDownloadPath();
        if (this.onSignatureListener != null) {
            this.headObjectRequest.setSign(this.onSignatureListener.onGetSign((CosXmlRequest)this.headObjectRequest));
        }
        this.getHttpMetrics((CosXmlRequest)this.headObjectRequest, "HeadObjectRequest");
        this.headObjectRequest.setTaskStateListener(new QCloudTaskStateListener(){

            public void onStateChanged(String taskId, int state) {
                if (COSXMLDownloadTask.this.IS_EXIT.get()) {
                    return;
                }
                if (state != 1) {
                    COSXMLDownloadTask.this.updateState(TransferState.IN_PROGRESS, null, null, false);
                }
            }
        });
        this.cosXmlService.headObjectAsync(this.headObjectRequest, new CosXmlResultListener(){

            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                File file;
                String absolutePath;
                if (request != COSXMLDownloadTask.this.headObjectRequest) {
                    return;
                }
                if (COSXMLDownloadTask.this.IS_EXIT.get()) {
                    return;
                }
                List eTags = (List)result.headers.get("ETag");
                if (eTags != null && eTags.size() > 0) {
                    COSXMLDownloadTask.this.eTag = (String)eTags.get(0);
                }
                if ((absolutePath = COSXMLDownloadTask.this.hasExisted()) != null && (file = new File(absolutePath)).exists()) {
                    long fileLength = file.length();
                    List contentLengths = (List)result.headers.get("Content-Length");
                    if (contentLengths != null && contentLengths.size() > 0 && Long.valueOf((String)contentLengths.get(0)) == fileLength) {
                        if (COSXMLDownloadTask.this.cosXmlProgressListener != null) {
                            COSXMLDownloadTask.this.cosXmlProgressListener.onProgress(fileLength, fileLength);
                        }
                        COSXMLDownloadTask.this.IS_EXIT.set(true);
                        COSXMLDownloadTask.this.updateState(TransferState.COMPLETED, null, result, false);
                        return;
                    }
                    COSXMLDownloadTask.this.hasWriteDataLen = fileLength - COSXMLDownloadTask.this.fileOffset;
                    COSXMLDownloadTask.this.realDownload(COSXMLDownloadTask.this.rangeStart + COSXMLDownloadTask.this.hasWriteDataLen, COSXMLDownloadTask.this.rangeEnd, COSXMLDownloadTask.this.fileOffset + COSXMLDownloadTask.this.hasWriteDataLen);
                    return;
                }
                FileUtils.deleteFileIfExist((String)downloadPath);
                COSXMLDownloadTask.this.save(COSXMLDownloadTask.this.getDownloadPath());
                COSXMLDownloadTask.this.hasWriteDataLen = 0L;
                COSXMLDownloadTask.this.realDownload(COSXMLDownloadTask.this.rangeStart, COSXMLDownloadTask.this.rangeEnd, COSXMLDownloadTask.this.fileOffset);
            }

            public void onFail(CosXmlRequest request, CosXmlClientException clientException, CosXmlServiceException serviceException) {
                if (request != COSXMLDownloadTask.this.headObjectRequest) {
                    return;
                }
                if (COSXMLDownloadTask.this.IS_EXIT.get()) {
                    return;
                }
                Throwable causeException = clientException == null ? serviceException : clientException;
                causeException.printStackTrace();
                COSXMLDownloadTask.this.updateState(TransferState.FAILED, (Exception)causeException, null, false);
                QCloudLogger.i((String)TAG, (String)("head " + COSXMLDownloadTask.this.cosPath + "failed !, exception is " + causeException.getMessage()), (Object[])new Object[0]);
            }
        });
    }

    @Override
    protected void internalCompleted() {
        this.clear();
    }

    @Override
    protected void internalFailed() {
        this.cancelAllRequest(false);
    }

    @Override
    protected void internalPause() {
        if (this.getObjectRequest != null) {
            BeaconService.getInstance().reportDownloadTaskSuccess((CosXmlRequest)this.getObjectRequest);
        }
        this.cancelAllRequest(false);
    }

    @Override
    protected void internalCancel(boolean now) {
        this.cancelAllRequest(now);
        this.clear();
    }

    @Override
    protected void internalResume() {
        this.taskState = TransferState.WAITING;
        this.IS_EXIT.set(false);
        this.download();
    }

    @Override
    protected void encounterError(@Nullable CosXmlRequest cosXmlRequest, CosXmlClientException clientException, CosXmlServiceException serviceException) {
        if (this.IS_EXIT.get()) {
            return;
        }
        this.IS_EXIT.set(true);
        this.updateState(TransferState.FAILED, COSUtils.mergeException(clientException, serviceException), null, false);
    }

    public static class COSXMLDownloadTaskResult
    extends CosXmlResult {
        public String eTag;

        protected COSXMLDownloadTaskResult() {
        }
    }

    public static class COSXMLDownloadTaskRequest
    extends GetObjectRequest {
        protected COSXMLDownloadTaskRequest(String region, String bucket, String cosPath, String savePath, String saveFileName, Map<String, List<String>> headers, Map<String, String> queryStr) {
            super(bucket, cosPath, savePath, saveFileName);
            this.setRegion(region);
            this.setRequestHeaders(headers);
            this.setQueryParameters(queryStr);
        }
    }
}

