/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.model.tag.ACLAccount;
import com.tencent.cos.xml.model.tag.AccessControlPolicy;
import com.tencent.cos.xml.transfer.XmlBuilder;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.io.IOException;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public final class PutObjectACLRequest
extends ObjectRequest {
    private AccessControlPolicy accessControlPolicy;

    public PutObjectACLRequest(String bucket, String cosPath) {
        super(bucket, cosPath);
    }

    public String getMethod() {
        return "PUT";
    }

    public Map<String, String> getQueryString() {
        this.queryParameters.put("acl", null);
        return super.getQueryString();
    }

    protected RequestBodySerializer xmlBuilder() throws XmlPullParserException, IOException {
        if (this.accessControlPolicy == null) {
            return RequestBodySerializer.bytes(null, (byte[])new byte[0]);
        }
        return RequestBodySerializer.string((String)"application/xml", (String)XmlBuilder.buildAccessControlPolicyXML(this.accessControlPolicy));
    }

    public void setAccessControlPolicy(AccessControlPolicy accessControlPolicy) {
        this.accessControlPolicy = accessControlPolicy;
    }

    public void setXCOSACL(COSACL cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl.getAcl());
        }
    }

    public void setXCOSACL(String cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl);
        }
    }

    public void setXCOSGrantRead(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-read", aclAccount.getAccount());
        }
    }

    public void setXCOSGrantWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-write", aclAccount.getAccount());
        }
    }

    public void setXCOSGrantReadACP(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-read-acp", aclAccount.getAccount());
        }
    }

    public void setXCOSGrantWriteACP(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-write-acp", aclAccount.getAccount());
        }
    }

    public void setXCOSReadFullControl(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-full-control", aclAccount.getAccount());
        }
    }

    public void setXCOSReadWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-full-control", aclAccount.getAccount());
        }
    }
}

