/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.common.COSStorageClass;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.model.object.TransferRequest;
import com.tencent.cos.xml.utils.DateUtils;
import com.tencent.cos.xml.utils.DigestUtils;
import com.tencent.qcloud.core.auth.COSXmlSignSourceProvider;
import com.tencent.qcloud.core.auth.QCloudCredentials;
import com.tencent.qcloud.core.auth.QCloudSignSourceProvider;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.MultipartStreamRequestBody;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import com.tencent.qcloud.core.util.QCloudHttpUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PostObjectRequest
extends ObjectRequest
implements TransferRequest {
    private FormStruct formStruct = new FormStruct();
    private CosXmlProgressListener progressListener;
    private long offset = 0L;
    private long contentLength = -1L;

    private PostObjectRequest(String bucket, String cosPath) {
        super(bucket, "/");
        this.formStruct.key = cosPath;
    }

    public PostObjectRequest(String bucket, String cosPath, String srcPath) {
        this(bucket, cosPath);
        this.formStruct.srcPath = srcPath;
    }

    public PostObjectRequest(String bucket, String cosPath, byte[] data) {
        this(bucket, cosPath);
        this.formStruct.data = data;
    }

    public PostObjectRequest(String bucket, String cosPath, InputStream inputStream) {
        this(bucket, cosPath);
        this.formStruct.inputStream = inputStream;
    }

    public void setRange(long offset, long contentSize) {
        this.offset = offset;
        this.contentLength = contentSize;
    }

    public String getMethod() {
        return "POST";
    }

    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        MultipartStreamRequestBody multipartStreamRequestBody = new MultipartStreamRequestBody();
        multipartStreamRequestBody.setBodyParameters(this.formStruct.getFormParameters());
        if (this.formStruct.srcPath != null) {
            File file = new File(this.formStruct.srcPath);
            multipartStreamRequestBody.setContent(null, "file", file.getName(), file, this.offset, this.contentLength);
            return RequestBodySerializer.multiPart((MultipartStreamRequestBody)multipartStreamRequestBody);
        }
        if (this.formStruct.data != null) {
            multipartStreamRequestBody.setContent(null, "file", "data.txt", this.formStruct.data, this.offset, this.contentLength);
            return RequestBodySerializer.multiPart((MultipartStreamRequestBody)multipartStreamRequestBody);
        }
        if (this.formStruct.inputStream != null) {
            try {
                File tmpFile = new File(CosXmlSimpleService.appCachePath, String.valueOf(System.currentTimeMillis()));
                multipartStreamRequestBody.setContent(null, "file", tmpFile.getName(), tmpFile, this.formStruct.inputStream, this.offset, this.contentLength);
                return RequestBodySerializer.multiPart((MultipartStreamRequestBody)multipartStreamRequestBody);
            }
            catch (IOException e2) {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), (Throwable)e2);
            }
        }
        return null;
    }

    public void setSignParamsAndHeaders(Set<String> parameters, Set<String> headers) {
        PostCosXmlSignSourceProvider cosXmlSignSourceProvider = new PostCosXmlSignSourceProvider();
        cosXmlSignSourceProvider.parameters(parameters);
        cosXmlSignSourceProvider.headers(headers);
        cosXmlSignSourceProvider.setHeaderPairsForSign(QCloudHttpUtils.transformToMultiMap(this.formStruct.getFormParameters()));
        this.setSignSourceProvider((QCloudSignSourceProvider)cosXmlSignSourceProvider);
    }

    public QCloudSignSourceProvider getSignSourceProvider() {
        if (this.signSourceProvider == null) {
            this.signSourceProvider = new PostCosXmlSignSourceProvider();
            ((COSXmlSignSourceProvider)this.signSourceProvider).setHeaderPairsForSign(QCloudHttpUtils.transformToMultiMap(this.formStruct.getFormParameters()));
        }
        return this.signSourceProvider;
    }

    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        this.formStruct.checkParameters();
    }

    public void setProgressListener(CosXmlProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public CosXmlProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setAcl(String acl) {
        this.formStruct.acl = acl;
    }

    public void setCacheControl(String cacheControl) {
        this.formStruct.headers.put("Cache-Control", cacheControl);
    }

    public void setContentType(String contentType) {
        this.formStruct.headers.put("Content-Type", contentType);
    }

    public void setContentDisposition(String contentDisposition) {
        this.formStruct.headers.put("Content-Disposition", contentDisposition);
    }

    public void setContentEncoding(String contentEncoding) {
        this.formStruct.headers.put("Content-Encoding", contentEncoding);
    }

    public void setExpires(String expires) {
        this.formStruct.headers.put("Expires", expires);
    }

    public void setStroageClass(COSStorageClass stroageClass) {
        this.formStruct.headers.put("x-cos-storage-class", stroageClass.getStorageClass());
    }

    public void setHeader(String key, String value) {
        if (key != null && value != null) {
            this.formStruct.headers.put(key, value);
        }
    }

    public void setCustomerHeader(String key, String value) {
        if (key != null && value != null) {
            this.formStruct.customHeaders.put(key, value);
        }
    }

    public void setCosStorageClass(String cosStorageClass) {
        this.formStruct.xCosStorageClass = cosStorageClass;
    }

    public void setSuccessActionRedirect(String redirectHost) {
        this.formStruct.successActionRedirect = redirectHost;
    }

    public void setSuccessActionStatus(int successHttpCode) {
        this.formStruct.successActionStatus = String.valueOf(successHttpCode);
    }

    public void setPolicy(Policy policy) {
        this.formStruct.policy = policy;
    }

    public void setTrafficLimit(long limit) {
        this.addHeader("x-cos-traffic-limit", String.valueOf(limit));
    }

    Map<String, String> testFormParameters() throws CosXmlClientException {
        return this.formStruct.getFormParameters();
    }

    public static class Policy {
        private String expiration;
        private JSONArray conditions = new JSONArray();

        public void setExpiration(long endTimeMills) {
            this.expiration = DateUtils.getFormatTime("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", endTimeMills);
        }

        public void setExpiration(String formatEndTime) {
            this.expiration = formatEndTime;
        }

        public void addConditions(String key, String value, boolean isPrefixMatch) throws CosXmlClientException {
            if (isPrefixMatch) {
                JSONArray content = new JSONArray();
                content.put((Object)"starts-with");
                content.put((Object)key);
                content.put((Object)value);
                this.conditions.put((Object)content);
            } else {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put(key, (Object)value);
                }
                catch (JSONException e2) {
                    throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), (Throwable)e2);
                }
                this.conditions.put((Object)jsonObject);
            }
        }

        public void addContentConditions(int start, int end) {
            JSONArray content = new JSONArray();
            content.put((Object)"content-length-range");
            content.put(start);
            content.put(end);
            this.conditions.put((Object)content);
        }

        public String content() {
            JSONObject jsonObject = new JSONObject();
            try {
                if (this.expiration != null) {
                    jsonObject.put("expiration", (Object)this.expiration);
                }
                jsonObject.put("conditions", (Object)this.conditions);
                return jsonObject.toString();
            }
            catch (JSONException jSONException) {
                return null;
            }
        }
    }

    private class FormStruct {
        String acl;
        Map<String, String> headers = new LinkedHashMap<String, String>();
        String key;
        String successActionRedirect;
        String successActionStatus;
        Map<String, String> customHeaders = new LinkedHashMap<String, String>();
        String xCosStorageClass;
        Policy policy;
        String srcPath;
        byte[] data;
        InputStream inputStream;

        public Map<String, String> getFormParameters() {
            LinkedHashMap<String, String> formParameters = new LinkedHashMap<String, String>();
            if (this.acl != null) {
                formParameters.put("acl", this.acl);
            }
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                formParameters.put(entry.getKey(), entry.getValue());
            }
            formParameters.put("key", this.key);
            if (this.successActionRedirect != null) {
                formParameters.put("success_action_redirect", this.successActionRedirect);
            }
            if (this.successActionStatus != null) {
                formParameters.put("success_action_status", this.successActionStatus);
            } else {
                formParameters.put("success_action_status", "204");
            }
            for (Map.Entry<String, String> entry : this.customHeaders.entrySet()) {
                formParameters.put(entry.getKey(), entry.getValue());
            }
            if (this.xCosStorageClass != null) {
                formParameters.put("x-cos-storage-class", this.xCosStorageClass);
            }
            if (this.policy != null) {
                try {
                    formParameters.put("policy", DigestUtils.getBase64((String)this.policy.content()));
                }
                catch (CosXmlClientException cosXmlClientException) {
                    // empty catch block
                }
            }
            return formParameters;
        }

        public void checkParameters() throws CosXmlClientException {
            File file;
            if (((PostObjectRequest)PostObjectRequest.this).formStruct.key == null) {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "cosPath = null ");
            }
            if (this.srcPath == null && this.data == null && this.inputStream == null) {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "data souce = null");
            }
            if (!(this.srcPath == null || (file = new File(this.srcPath)).exists() && file.isFile())) {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "srcPath is invalid");
            }
        }
    }

    private static class PostCosXmlSignSourceProvider
    extends COSXmlSignSourceProvider {
        private PostCosXmlSignSourceProvider() {
        }

        public <T> void onSignRequestSuccess(HttpRequest<T> request, QCloudCredentials credentials, String authorization) {
            super.onSignRequestSuccess(request, credentials, authorization);
            MultipartStreamRequestBody requestBody = (MultipartStreamRequestBody)request.getRequestBody();
            requestBody.setSign(authorization);
            request.removeHeader("Authorization");
        }
    }
}

