/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.model.bucket.BucketRequest;
import com.tencent.cos.xml.model.tag.ACLAccount;
import com.tencent.cos.xml.model.tag.CreateBucketConfiguration;
import com.tencent.cos.xml.transfer.XmlBuilder;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.io.IOException;
import okhttp3.RequestBody;
import org.xmlpull.v1.XmlPullParserException;

public final class PutBucketRequest
extends BucketRequest {
    private CreateBucketConfiguration createBucketConfiguration = null;

    public PutBucketRequest(String bucket) {
        super(bucket);
    }

    public void enableMAZ(boolean enable) {
        this.createBucketConfiguration = enable ? new CreateBucketConfiguration() : null;
    }

    public void setXCOSACL(String cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl);
        }
    }

    public void setXCOSACL(COSACL cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl.getAcl());
        }
    }

    public void setXCOSGrantRead(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-read", aclAccount.getAccount());
        }
    }

    public void setXCOSGrantRead(String aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-read", aclAccount);
        }
    }

    public void setXCOSGrantWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-write", aclAccount.getAccount());
        }
    }

    public void setXCOSGrantWrite(String aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-write", aclAccount);
        }
    }

    public void setXCOSReadWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-full-control", aclAccount.getAccount());
        }
    }

    public void setXCOSReadWrite(String aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-full-control", aclAccount);
        }
    }

    public String getMethod() {
        return "PUT";
    }

    protected RequestBodySerializer xmlBuilder() throws XmlPullParserException, IOException {
        if (this.createBucketConfiguration != null) {
            return RequestBodySerializer.string((String)"application/xml", (String)XmlBuilder.buildCreateBucketConfiguration(this.createBucketConfiguration));
        }
        return RequestBodySerializer.wrap((RequestBody)RequestBody.create(null, (byte[])new byte[0]));
    }
}

