/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.tencent.cos.xml.common.VersionInfo;
import com.tencent.qcloud.core.http.s;
import com.tencent.qcloud.core.task.g;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class CosXmlServiceConfig
implements Parcelable {
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String ACCELERATE_ENDPOINT_SUFFIX = "cos.accelerate";
    public static final String DEFAULT_HOST_FORMAT = "${bucket}.cos.${region}.myqcloud.com";
    public static final String ACCELERATE_HOST_FORMAT = "${bucket}.cos.accelerate.myqcloud.com";
    public static final String PATH_STYLE_HOST_FORMAT = "cos.${region}.myqcloud.com";
    public static final String DEFAULT_USER_AGENT = VersionInfo.getUserAgent();
    public static final Parcelable.Creator<CosXmlServiceConfig> CREATOR = new Parcelable.Creator<CosXmlServiceConfig>(){

        public CosXmlServiceConfig createFromParcel(Parcel parcel) {
            return new CosXmlServiceConfig(parcel);
        }

        public CosXmlServiceConfig[] newArray(int n2) {
            return new CosXmlServiceConfig[n2];
        }
    };
    public String protocol;
    public String userAgent;
    public String region;
    public String host;
    public int port;
    public String endpointSuffix;
    public boolean isDebuggable;
    public g retryStrategy;
    public s qCloudHttpRetryHandler;
    public int connectionTimeout;
    public int socketTimeout;
    public Executor executor;
    public Executor observeExecutor;
    public Map<String, List<String>> commonHeaders;
    public List<String> noSignHeaders;
    public String hostFormat;
    public String hostHeaderFormat;
    public boolean bucketInPath;
    public boolean accelerate;
    public boolean transferThreadControl;

    public CosXmlServiceConfig(Builder builder) {
        this.hostFormat = DEFAULT_HOST_FORMAT;
        this.hostHeaderFormat = null;
        this.transferThreadControl = true;
        this.protocol = builder.protocol;
        this.userAgent = builder.userAgent;
        this.isDebuggable = builder.isDebuggable;
        this.region = builder.region;
        this.host = builder.host;
        this.port = builder.port;
        this.endpointSuffix = builder.endpointSuffix;
        this.bucketInPath = builder.bucketInPath;
        this.commonHeaders = builder.commonHeaders;
        this.noSignHeaders = builder.noSignHeaders;
        if (TextUtils.isEmpty((CharSequence)this.hostFormat) && TextUtils.isEmpty((CharSequence)this.region) && TextUtils.isEmpty((CharSequence)this.host)) {
            throw new IllegalArgumentException("please set host or endpointSuffix or region !");
        }
        this.retryStrategy = builder.retryStrategy;
        this.qCloudHttpRetryHandler = builder.qCloudHttpRetryHandler;
        this.socketTimeout = builder.socketTimeout;
        this.connectionTimeout = builder.connectionTimeout;
        this.hostFormat = builder.hostFormat;
        this.hostHeaderFormat = builder.hostHeaderFormat;
        this.executor = builder.executor;
        this.observeExecutor = builder.observeExecutor;
        this.accelerate = builder.accelerate;
        this.transferThreadControl = builder.transferThreadControl;
    }

    private String getFormatHost(String string, String string2, String string3) {
        return string.replace("${bucket}", string3).replace("${region}", string2);
    }

    private String getHostFormat(boolean bl, boolean bl2) {
        if (!TextUtils.isEmpty((CharSequence)this.hostFormat)) {
            return this.hostFormat;
        }
        String string = DEFAULT_HOST_FORMAT;
        if (bl) {
            string = ACCELERATE_HOST_FORMAT;
        } else if (bl2) {
            string = PATH_STYLE_HOST_FORMAT;
        }
        String string2 = this.endpointSuffix;
        if (string2 != null) {
            if (!this.bucketInPath) {
                string2 = "${bucket}.".concat(string2);
            }
            if (bl) {
                string2 = string2.replace("cos.${region}", ACCELERATE_ENDPOINT_SUFFIX);
            }
        } else {
            string2 = string;
        }
        return string2;
    }

    private String substituteEndpointSuffix(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string) && string2 != null) {
            return string.replace("${region}", string2);
        }
        return string;
    }

    public CosXmlServiceConfig(Parcel object) {
        Parcel parcel = object;
        object = new Builder().isHttps(HTTPS_PROTOCOL.equals(object.readString())).setRegion(object.readString());
        boolean bl = parcel.readInt() == 1;
        this(((Builder)object).setDebuggable(bl));
    }

    public /* synthetic */ CosXmlServiceConfig(Parcel parcel, 1 var2_2) {
        this(parcel);
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getRegion() {
        return this.region;
    }

    public List<String> getNoSignHeaders() {
        return this.noSignHeaders;
    }

    public String getRequestHost(String string, boolean bl) {
        return this.getRequestHost(null, string, bl);
    }

    public String getRequestHost(String string, String string2, boolean bl) {
        bl = bl || this.accelerate;
        return this.getRequestHost(string, string2, this.getHostFormat(bl, this.bucketInPath));
    }

    public String getRequestHost(String string, String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)this.host)) {
            return this.host;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = this.region;
        }
        return this.getFormatHost(string3, string, string2);
    }

    public int getPort() {
        return this.port;
    }

    public Map<String, List<String>> getCommonHeaders() {
        return this.commonHeaders;
    }

    public boolean isTransferThreadControl() {
        return this.transferThreadControl;
    }

    public String getUrlPath(String string, String string2) {
        StringBuilder stringBuilder;
        CosXmlServiceConfig cosXmlServiceConfig = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (cosXmlServiceConfig.bucketInPath) {
            stringBuilder2.append("/").append(string);
        }
        if (string2 != null && !string2.startsWith("/")) {
            stringBuilder2.append("/").append(string2);
        } else {
            stringBuilder2.append(string2);
        }
        return stringBuilder2.toString();
    }

    @Deprecated
    public String getEndpointSuffix() {
        CosXmlServiceConfig cosXmlServiceConfig = this;
        return cosXmlServiceConfig.getEndpointSuffix(cosXmlServiceConfig.region, false);
    }

    public String getEndpointSuffix(String string, boolean bl) {
        String string2;
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = ((CosXmlServiceConfig)object).getRegion();
        }
        if ((string2 = ((CosXmlServiceConfig)object).endpointSuffix) == null && string != null) {
            string2 = "cos." + string + ".myqcloud.com";
        }
        if ((object = ((CosXmlServiceConfig)object).substituteEndpointSuffix(string2, string)) != null && bl) {
            Object object = ((String)object).replace("cos." + string, ACCELERATE_ENDPOINT_SUFFIX);
        }
        return object;
    }

    public boolean isDebuggable() {
        return this.isDebuggable;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public g getRetryStrategy() {
        return this.retryStrategy;
    }

    public s getQCloudHttpRetryHandler() {
        return this.qCloudHttpRetryHandler;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Executor getObserveExecutor() {
        return this.observeExecutor;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.protocol);
        parcel.writeString(this.region);
        parcel.writeInt(this.isDebuggable ? 1 : 0);
    }

    public static final class Builder {
        public String protocol;
        public String userAgent;
        public String region;
        public String appid;
        public String host;
        public int port;
        public String endpointSuffix;
        public boolean bucketInPath;
        public boolean isDebuggable;
        public g retryStrategy;
        public s qCloudHttpRetryHandler;
        public int connectionTimeout;
        public int socketTimeout;
        public Executor executor;
        public Executor observeExecutor;
        public boolean dnsCache;
        public Map<String, List<String>> commonHeaders;
        public List<String> noSignHeaders;
        public String hostFormat;
        public String hostHeaderFormat;
        public boolean accelerate;
        public boolean transferThreadControl;

        public Builder() {
            this.port = -1;
            this.connectionTimeout = 15000;
            this.socketTimeout = 30000;
            this.dnsCache = true;
            this.commonHeaders = new HashMap<String, List<String>>();
            this.noSignHeaders = new LinkedList<String>();
            this.transferThreadControl = true;
            this.protocol = CosXmlServiceConfig.HTTPS_PROTOCOL;
            this.userAgent = DEFAULT_USER_AGENT;
            this.isDebuggable = false;
            this.retryStrategy = g.a;
            this.bucketInPath = false;
        }

        public Builder(CosXmlServiceConfig cosXmlServiceConfig) {
            Builder builder = this;
            this.port = -1;
            this.connectionTimeout = 15000;
            this.socketTimeout = 30000;
            this.dnsCache = true;
            this.commonHeaders = new HashMap<String, List<String>>();
            this.noSignHeaders = new LinkedList<String>();
            this.transferThreadControl = true;
            builder.protocol = cosXmlServiceConfig.protocol;
            builder.userAgent = DEFAULT_USER_AGENT;
            this.region = cosXmlServiceConfig.region;
            this.host = cosXmlServiceConfig.host;
            this.port = cosXmlServiceConfig.port;
            this.endpointSuffix = cosXmlServiceConfig.endpointSuffix;
            this.bucketInPath = cosXmlServiceConfig.bucketInPath;
            this.isDebuggable = cosXmlServiceConfig.isDebuggable;
            this.retryStrategy = cosXmlServiceConfig.retryStrategy;
            this.qCloudHttpRetryHandler = cosXmlServiceConfig.qCloudHttpRetryHandler;
            this.connectionTimeout = cosXmlServiceConfig.connectionTimeout;
            this.socketTimeout = cosXmlServiceConfig.socketTimeout;
            this.executor = cosXmlServiceConfig.executor;
            this.observeExecutor = cosXmlServiceConfig.observeExecutor;
            this.commonHeaders = cosXmlServiceConfig.commonHeaders;
            this.noSignHeaders = cosXmlServiceConfig.noSignHeaders;
            this.hostFormat = cosXmlServiceConfig.hostFormat;
            this.hostHeaderFormat = cosXmlServiceConfig.hostHeaderFormat;
            this.accelerate = cosXmlServiceConfig.accelerate;
            this.transferThreadControl = cosXmlServiceConfig.transferThreadControl;
        }

        public static /* synthetic */ String access$000(Builder builder) {
            return builder.protocol;
        }

        public static /* synthetic */ String access$100(Builder builder) {
            return builder.userAgent;
        }

        public static /* synthetic */ boolean access$200(Builder builder) {
            return builder.isDebuggable;
        }

        public static /* synthetic */ String access$300(Builder builder) {
            return builder.region;
        }

        public static /* synthetic */ String access$400(Builder builder) {
            return builder.host;
        }

        public static /* synthetic */ int access$500(Builder builder) {
            return builder.port;
        }

        public static /* synthetic */ String access$600(Builder builder) {
            return builder.endpointSuffix;
        }

        public static /* synthetic */ boolean access$700(Builder builder) {
            return builder.bucketInPath;
        }

        public static /* synthetic */ Map access$800(Builder builder) {
            return builder.commonHeaders;
        }

        public static /* synthetic */ List access$900(Builder builder) {
            return builder.noSignHeaders;
        }

        public static /* synthetic */ g access$1000(Builder builder) {
            return builder.retryStrategy;
        }

        public static /* synthetic */ s access$1100(Builder builder) {
            return builder.qCloudHttpRetryHandler;
        }

        public static /* synthetic */ int access$1200(Builder builder) {
            return builder.socketTimeout;
        }

        public static /* synthetic */ int access$1300(Builder builder) {
            return builder.connectionTimeout;
        }

        public static /* synthetic */ String access$1400(Builder builder) {
            return builder.hostFormat;
        }

        public static /* synthetic */ String access$1500(Builder builder) {
            return builder.hostHeaderFormat;
        }

        public static /* synthetic */ Executor access$1600(Builder builder) {
            return builder.executor;
        }

        public static /* synthetic */ Executor access$1700(Builder builder) {
            return builder.observeExecutor;
        }

        public static /* synthetic */ boolean access$1800(Builder builder) {
            return builder.accelerate;
        }

        public static /* synthetic */ boolean access$1900(Builder builder) {
            return builder.transferThreadControl;
        }

        public Builder setConnectionTimeout(int n2) {
            this.connectionTimeout = n2;
            return this;
        }

        public Builder setSocketTimeout(int n2) {
            this.socketTimeout = n2;
            return this;
        }

        public Builder setTransferThreadControl(boolean bl) {
            this.transferThreadControl = bl;
            return this;
        }

        public Builder isHttps(boolean bl) {
            this.protocol = bl ? CosXmlServiceConfig.HTTPS_PROTOCOL : CosXmlServiceConfig.HTTP_PROTOCOL;
            return this;
        }

        public Builder setHostFormat(String string) {
            this.hostFormat = string;
            return this;
        }

        @Deprecated
        public Builder setAppidAndRegion(String string, String string2) {
            this.appid = string;
            this.region = string2;
            return this;
        }

        public Builder setRegion(String string) {
            this.region = string;
            return this;
        }

        @Deprecated
        public Builder setEndpointSuffix(String string) {
            this.endpointSuffix = string;
            return this;
        }

        public Builder setHost(String string) {
            this.host = string;
            return this;
        }

        public Builder setHost(Uri uri) {
            this.host = uri.getHost();
            if (uri.getPort() != -1) {
                this.port = uri.getPort();
            }
            this.protocol = uri.getScheme();
            return this;
        }

        public Builder setDebuggable(boolean bl) {
            this.isDebuggable = bl;
            return this;
        }

        public Builder setRetryStrategy(g g2) {
            this.retryStrategy = g2;
            return this;
        }

        public Builder setRetryHandler(s s2) {
            this.qCloudHttpRetryHandler = s2;
            return this;
        }

        @Deprecated
        public Builder setBucketInPath(boolean bl) {
            this.bucketInPath = bl;
            return this;
        }

        public Builder setPathStyle(boolean bl) {
            this.bucketInPath = bl;
            return this;
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder setObserveExecutor(Executor executor) {
            this.observeExecutor = executor;
            return this;
        }

        public Builder setAccelerate(boolean bl) {
            this.accelerate = bl;
            return this;
        }

        public CosXmlServiceConfig builder() {
            return new CosXmlServiceConfig(this);
        }

        public Builder addHeader(String string, String string2) {
            LinkedList<String> linkedList = this.commonHeaders.get(string);
            if (linkedList == null) {
                LinkedList<String> linkedList2;
                linkedList = linkedList2;
                linkedList2 = new LinkedList<String>();
            }
            Builder builder = this;
            linkedList.add(string2);
            builder.commonHeaders.put(string, linkedList);
            return builder;
        }

        public Builder addNoSignHeaders(String string) {
            Builder builder = this;
            builder.noSignHeaders.add(string);
            return builder;
        }
    }
}

