/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import bolts.CancellationTokenSource;
import com.tencent.cos.xml.CosTrackService;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.crypto.COSDirect;
import com.tencent.cos.xml.crypto.CryptoModuleBase;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.cos.xml.transfer.TransferStateListener;
import com.tencent.cos.xml.transfer.TransferTaskMetrics;
import com.tencent.qcloud.core.logger.COSLogger;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class COSTransferTask {
    protected String region;
    protected String bucket;
    protected String key;
    protected CosXmlProgressListener cosXmlProgressListener;
    protected CosXmlResultListener cosXmlResultListener;
    protected TransferStateListener transferStateListener;
    volatile TransferState taskState = TransferState.WAITING;
    protected CosXmlRequest cosXmlRequest;
    protected CosXmlResult cosXmlResult;
    protected CosXmlClientException clientException;
    protected CosXmlServiceException serviceException;
    protected volatile TransferTaskMetrics transferTaskMetrics;
    protected volatile String taskId;
    protected volatile boolean manualPause = false;
    protected volatile boolean manualCancel = false;
    protected volatile CancellationTokenSource mTransferTaskCts;
    private final String TAG;
    protected CosXmlServiceConfig cosXmlServiceConfig;
    protected COSDirect cosDirect;
    protected CryptoModuleBase cryptoModuleBase;

    COSTransferTask(COSDirect cosDirect, ObjectRequest cosXmlRequest) {
        this.cosXmlServiceConfig = cosDirect.getCosService().getConfig();
        this.taskId = UUID.randomUUID().toString();
        this.cosXmlRequest = cosXmlRequest;
        this.cosDirect = cosDirect;
        this.bucket = cosXmlRequest.getBucket();
        this.region = cosXmlRequest.getRegion();
        if (TextUtils.isEmpty((CharSequence)this.region)) {
            this.region = this.cosXmlServiceConfig.getRegion();
            cosXmlRequest.setRegion(this.region);
        }
        this.key = cosXmlRequest.getCosPath();
        this.TAG = this.tag();
        if (cosDirect.isTransferSecurely()) {
            COSTransferTask.loggerInfo(this.TAG, this.taskId, "encrypted transmission enabled", new Object[0]);
        }
        COSTransferTask.loggerInfo(this.TAG, this.taskId, "create a %s task, region: %s, bucket: %s, key: %s", cosXmlRequest.getClass().getSimpleName(), this.region, this.bucket, this.key);
    }

    public void setCosXmlResultListener(CosXmlResultListener cosXmlResultListener) {
        this.cosXmlResultListener = cosXmlResultListener;
        if (this.taskState == TransferState.COMPLETED) {
            this.notifyTransferResultSuccess(this.cosXmlRequest, this.cosXmlResult);
        } else if (this.taskState == TransferState.FAILED) {
            this.notifyTransferResultFailed(this.cosXmlRequest, this.clientException, this.serviceException);
        }
    }

    public void setTransferStateListener(TransferStateListener transferStateListener) {
        this.transferStateListener = transferStateListener;
        this.notifyTransferStateChange();
    }

    public void setCosXmlProgressListener(CosXmlProgressListener cosXmlProgressListener) {
        this.cosXmlProgressListener = cosXmlProgressListener;
    }

    protected void start() {
        this.manualPause = false;
        this.manualCancel = false;
        this.transferTaskMetrics = new TransferTaskMetrics();
        this.transferTaskMetrics.domain = this.cosXmlRequest.getRequestHost(this.cosXmlServiceConfig);
        this.onTransferWaiting();
        this.mTransferTaskCts = new CancellationTokenSource();
        this.executor().execute(new TransferRunnable());
    }

    public void pause() {
        if (this.taskState != TransferState.IN_PROGRESS && this.taskState != TransferState.WAITING) {
            COSTransferTask.loggerInfo(this.TAG, this.taskId, "cannot pause upload task in state %s", new Object[]{this.taskState});
            return;
        }
        COSTransferTask.loggerInfo(this.TAG, this.taskId, "pause upload task", new Object[0]);
        this.manualPause = true;
        this.onTransferPaused();
        if (this.mTransferTaskCts != null) {
            this.mTransferTaskCts.cancel();
        }
    }

    public void pause(boolean now) {
        this.pause();
    }

    public void resume() {
        if (this.taskState != TransferState.PAUSED) {
            COSTransferTask.loggerInfo(this.TAG, this.taskId, "cannot resume upload task in state %s", new Object[]{this.taskState});
            return;
        }
        COSTransferTask.loggerInfo(this.TAG, this.taskId, "resume upload task", new Object[]{this.taskState});
        this.start();
    }

    public void cancel() {
        COSTransferTask.loggerInfo(this.TAG, this.taskId, "cancel upload task", new Object[0]);
        this.manualCancel = true;
        this.onTransferFailed(this.cosXmlRequest, CosXmlClientException.manualCancelException(), null);
        if (this.mTransferTaskCts != null) {
            this.mTransferTaskCts.cancel();
        }
    }

    public void cancel(boolean now) {
        this.cancel();
    }

    public TransferTaskMetrics getTransferTaskMetrics() {
        return this.transferTaskMetrics;
    }

    protected abstract String tag();

    protected abstract Executor executor();

    protected abstract CosXmlResult execute() throws Exception;

    protected void checking() throws CosXmlClientException {
        if (TextUtils.isEmpty((CharSequence)this.bucket)) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "bucket is null");
        }
        if (TextUtils.isEmpty((CharSequence)this.region)) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "region is null");
        }
    }

    public TransferState getTaskState() {
        return this.taskState;
    }

    protected void onTransferWaiting() {
        this.taskState = TransferState.WAITING;
        this.transferTaskMetrics.onStart();
        this.notifyTransferStateChange();
    }

    protected void onTransferInProgress() {
        this.taskState = TransferState.IN_PROGRESS;
        this.transferTaskMetrics.onInProgress();
        this.notifyTransferStateChange();
    }

    protected void onTransferPaused() {
        this.taskState = TransferState.PAUSED;
        this.transferTaskMetrics.onComplete();
        this.notifyTransferStateChange();
    }

    protected void onTransferSuccess(CosXmlRequest cosXmlRequest, CosXmlResult cosXmlResult) {
        this.cosXmlResult = cosXmlResult;
        this.taskState = TransferState.COMPLETED;
        this.transferTaskMetrics.onComplete();
        this.notifyTransferStateChange();
        this.notifyTransferResultSuccess(cosXmlRequest, cosXmlResult);
        CosTrackService.getInstance().reportTransferSuccess(cosXmlRequest, this.transferTaskMetrics, this.cosDirect.isTransferSecurely());
    }

    protected void onTransferFailed(CosXmlRequest cosXmlRequest, CosXmlClientException clientException, CosXmlServiceException serviceException) {
        if (clientException != null) {
            COSTransferTask.loggerInfo(this.TAG, this.taskId, "transfer failed, clientException=%d, %s", clientException.errorCode, clientException.getMessage());
        } else if (serviceException != null) {
            COSTransferTask.loggerInfo(this.TAG, this.taskId, "transfer failed, serviceException=%s, %s", serviceException.getErrorCode(), serviceException.getErrorMessage());
        }
        this.clientException = clientException;
        this.serviceException = serviceException;
        this.transferTaskMetrics.onComplete();
        this.taskState = TransferState.FAILED;
        this.notifyTransferStateChange();
        this.notifyTransferResultFailed(cosXmlRequest, clientException, serviceException);
        if (clientException != null) {
            CosTrackService.getInstance().reportTransferClientException(cosXmlRequest, this.transferTaskMetrics, clientException, this.cosDirect.isTransferSecurely());
        } else if (serviceException != null) {
            CosTrackService.getInstance().reportTransferServiceException(cosXmlRequest, this.transferTaskMetrics, serviceException, this.cosDirect.isTransferSecurely());
        }
    }

    protected synchronized void onTransferProgressChange(long complete, long target) {
        this.transferTaskMetrics.onFirstProgressCallback();
        this.notifyTransferProgressChange(complete, target);
    }

    protected boolean isManualPaused() {
        return this.manualPause;
    }

    protected boolean isManualCanceled() {
        return this.manualCancel;
    }

    private void notifyTransferStateChange() {
        if (this.transferStateListener != null) {
            this.transferStateListener.onStateChanged(this.taskState);
        }
    }

    private void notifyTransferProgressChange(long complete, long target) {
        if (this.cosXmlProgressListener != null && this.taskState == TransferState.IN_PROGRESS) {
            this.cosXmlProgressListener.onProgress(complete, target);
        }
    }

    private void notifyTransferResultSuccess(CosXmlRequest cosXmlRequest, CosXmlResult cosXmlResult) {
        if (this.cosXmlResultListener != null) {
            this.cosXmlResultListener.onSuccess(cosXmlRequest, cosXmlResult);
        }
    }

    private void notifyTransferResultFailed(CosXmlRequest cosXmlRequest, CosXmlClientException clientException, CosXmlServiceException serviceException) {
        if (serviceException != null && TextUtils.isEmpty((CharSequence)serviceException.getErrorCode())) {
            serviceException.setErrorCode(serviceException.getHttpMessage());
        }
        if (this.cosXmlResultListener != null) {
            this.cosXmlResultListener.onFail(cosXmlRequest, clientException, serviceException);
        }
    }

    public CosXmlClientException getClientException() {
        return this.clientException;
    }

    public CosXmlServiceException getServiceException() {
        return this.serviceException;
    }

    protected static void loggerInfo(String tag, String taskId, String format, Object ... params) {
        COSLogger.iProcess((String)tag, (String)("[%s]: " + format), (Object[])COSTransferTask.compose(taskId, params));
    }

    protected static void loggerWarn(String tag, String taskId, String format, Object ... params) {
        COSLogger.wProcess((String)tag, (String)("[%s]: " + format), (Object[])COSTransferTask.compose(taskId, params));
    }

    private static Object[] compose(String taskId, Object ... paras) {
        Object[] result = new Object[paras.length + 1];
        result[0] = taskId;
        System.arraycopy(paras, 0, result, 1, paras.length);
        return result;
    }

    protected static final class TaskThreadFactory
    implements ThreadFactory {
        private final AtomicInteger increment = new AtomicInteger(1);
        private final String tag;
        private final int priority;

        TaskThreadFactory(String tag, int priority) {
            this.tag = tag;
            this.priority = priority;
        }

        @Override
        public final Thread newThread(@NonNull Runnable runnable) {
            Thread newThread = new Thread(runnable, this.tag + this.increment.getAndIncrement());
            newThread.setDaemon(false);
            newThread.setPriority(this.priority);
            return newThread;
        }
    }

    private class TransferRunnable
    implements Runnable {
        private TransferRunnable() {
        }

        @Override
        public void run() {
            block6: {
                try {
                    COSTransferTask.this.onTransferInProgress();
                    COSTransferTask.this.checking();
                    COSTransferTask.this.cosXmlResult = COSTransferTask.this.execute();
                    COSTransferTask.this.onTransferSuccess(COSTransferTask.this.cosXmlRequest, COSTransferTask.this.cosXmlResult);
                }
                catch (CosXmlClientException clientException) {
                    if (!(COSTransferTask.this.isManualPaused() || COSTransferTask.this.isManualCanceled() || "task unknown status".equals(clientException.getMessage()))) {
                        COSTransferTask.this.onTransferFailed(COSTransferTask.this.cosXmlRequest, clientException, null);
                    }
                }
                catch (CosXmlServiceException serviceException) {
                    if (!COSTransferTask.this.isManualPaused() && !COSTransferTask.this.isManualCanceled()) {
                        COSTransferTask.this.onTransferFailed(COSTransferTask.this.cosXmlRequest, null, serviceException);
                    }
                }
                catch (Exception exception) {
                    if (COSTransferTask.this.isManualPaused() || COSTransferTask.this.isManualCanceled()) break block6;
                    COSTransferTask.this.onTransferFailed(COSTransferTask.this.cosXmlRequest, new CosXmlClientException(ClientErrorCode.UNKNOWN.getCode(), exception.getMessage()), null);
                }
            }
        }
    }
}

