/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.crypto;

import android.text.TextUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectMetadata {
    private static final long serialVersionUID = 1L;
    private Map<String, String> userMetadata;
    private Map<String, Object> metadata;
    private Date httpExpiresDate;
    private Date expirationTime;
    private String expirationTimeRuleId;
    private Boolean ongoingRestore;
    private Date restoreExpirationTime;
    private boolean isDeleteMarker;

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public void setHeader(String key, Object value) {
        this.metadata.put(key, value);
    }

    public void addUserMetadata(String key, String value) {
        this.userMetadata.put(key, value);
    }

    public Map<String, Object> getRawMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public Object getRawMetadataValue(String key) {
        return this.metadata.get(key);
    }

    public Date getLastModified() {
        return (Date)this.metadata.get("Last-Modified");
    }

    public void setLastModified(Date lastModified) {
        this.metadata.put("Last-Modified", lastModified);
    }

    public long getContentLength() {
        Long contentLength = (Long)this.metadata.get("Content-Length");
        if (contentLength == null) {
            return 0L;
        }
        return contentLength;
    }

    public long getInstanceLength() {
        int pos;
        String contentRange = (String)this.metadata.get("Content-Range");
        if (contentRange != null && (pos = contentRange.lastIndexOf("/")) >= 0) {
            return Long.parseLong(contentRange.substring(pos + 1));
        }
        return this.getContentLength();
    }

    public void setContentLength(long contentLength) {
        this.metadata.put("Content-Length", contentLength);
    }

    public String getContentType() {
        return (String)this.metadata.get("Content-Type");
    }

    public void setContentType(String contentType) {
        this.metadata.put("Content-Type", contentType);
    }

    public String getContentLanguage() {
        return (String)this.metadata.get("Content-Language");
    }

    public void setContentLanguage(String contentLanguage) {
        this.metadata.put("Content-Language", contentLanguage);
    }

    public String getContentEncoding() {
        return (String)this.metadata.get("Content-Encoding");
    }

    public void setContentEncoding(String encoding) {
        this.metadata.put("Content-Encoding", encoding);
    }

    public String getCacheControl() {
        return (String)this.metadata.get("Cache-Control");
    }

    public void setCacheControl(String cacheControl) {
        this.metadata.put("Cache-Control", cacheControl);
    }

    public void setContentMD5(String md5Base64) {
        if (md5Base64 == null) {
            this.metadata.remove("Content-MD5");
        } else {
            this.metadata.put("Content-MD5", md5Base64);
        }
    }

    public String getContentMD5() {
        return (String)this.metadata.get("Content-MD5");
    }

    public void setContentDisposition(String disposition) {
        this.metadata.put("Content-Disposition", disposition);
    }

    public String getContentDisposition() {
        return (String)this.metadata.get("Content-Disposition");
    }

    public String getETag() {
        return (String)this.metadata.get("ETag");
    }

    public String getVersionId() {
        return (String)this.metadata.get("x-cos-version-id");
    }

    public String getServerSideEncryption() {
        return (String)this.metadata.get("x-cos-server-side-encryption");
    }

    public void setServerSideEncryption(String serverSideEncryption) {
        this.metadata.put("x-cos-server-side-encryption", serverSideEncryption);
    }

    public void setSecurityToken(String securityToken) {
        this.metadata.put("x-cos-security-token", securityToken);
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public void setHttpExpiresDate(Date httpExpiresDate) {
        this.httpExpiresDate = httpExpiresDate;
    }

    public Date getHttpExpiresDate() {
        return this.httpExpiresDate;
    }

    public Date getRestoreExpirationTime() {
        return this.restoreExpirationTime;
    }

    public void setRestoreExpirationTime(Date restoreExpirationTime) {
        this.restoreExpirationTime = restoreExpirationTime;
    }

    public void setOngoingRestore(boolean ongoingRestore) {
        this.ongoingRestore = ongoingRestore;
    }

    public Boolean getOngoingRestore() {
        return this.ongoingRestore;
    }

    public boolean isDeleteMarker() {
        return this.isDeleteMarker;
    }

    public void setDeleteMarker(boolean isDeleteMarker) {
        this.isDeleteMarker = isDeleteMarker;
    }

    public String getUserMetaDataOf(String key) {
        return this.userMetadata == null ? null : this.userMetadata.get(key);
    }

    public ObjectMetadata() {
        this.userMetadata = new HashMap<String, String>();
        this.metadata = new HashMap<String, Object>();
    }

    public ObjectMetadata(Map<String, List<String>> headers) {
        this.userMetadata = new HashMap<String, String>();
        this.metadata = new HashMap<String, Object>();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            String value = null;
            if (values != null && !values.isEmpty()) {
                value = values.get(0);
            }
            if (TextUtils.isEmpty((CharSequence)key) || value == null) continue;
            if (key.startsWith("x-cos-meta-")) {
                this.userMetadata.put(key, value);
                continue;
            }
            this.metadata.put(key, value);
        }
    }

    private ObjectMetadata(ObjectMetadata from) {
        this.userMetadata = from.userMetadata == null ? null : new HashMap<String, String>(from.userMetadata);
        this.metadata = from.metadata == null ? null : new HashMap<String, Object>(from.metadata);
        this.expirationTime = from.expirationTime;
        this.expirationTimeRuleId = from.expirationTimeRuleId;
        this.httpExpiresDate = from.httpExpiresDate;
    }

    public ObjectMetadata clone() {
        return new ObjectMetadata(this);
    }

    public String getSSEAlgorithm() {
        return (String)this.metadata.get("x-cos-server-side-encryption");
    }

    public void setSSEAlgorithm(String algorithm) {
        this.metadata.put("x-cos-server-side-encryption", algorithm);
    }

    public String getSSECustomerAlgorithm() {
        return (String)this.metadata.get("x-cos-server-side-encryption-customer-algorithm");
    }

    public void setSSECustomerAlgorithm(String algorithm) {
        this.metadata.put("x-cos-server-side-encryption-customer-algorithm", algorithm);
    }

    public String getSSECustomerKeyMd5() {
        return (String)this.metadata.get("x-cos-server-side-encryption-customer-key-MD5");
    }

    public void setSSECustomerKeyMd5(String md5Digest) {
        this.metadata.put("x-cos-server-side-encryption-customer-key-MD5", md5Digest);
    }

    public String getStorageClass() {
        Object storageClass = this.metadata.get("x-cos-storage-class");
        if (storageClass == null) {
            return null;
        }
        return storageClass.toString();
    }

    public String getSSECOSKmsKeyId() {
        return (String)this.metadata.get("x-cos-server-side-encryption-qcloud-kms-key-id");
    }

    public String getCrc64Ecma() {
        return (String)this.metadata.get("x-cos-hash-crc64ecma");
    }
}

