/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.crypto;

import com.tencent.cos.xml.crypto.COSCryptoScheme;
import com.tencent.cos.xml.crypto.COSKeyWrapScheme;
import com.tencent.cos.xml.crypto.CipherLite;
import com.tencent.cos.xml.crypto.ContentCryptoScheme;
import com.tencent.cos.xml.crypto.EncryptionMaterials;
import com.tencent.cos.xml.crypto.EncryptionMaterialsAccessor;
import com.tencent.cos.xml.crypto.JSONUtils;
import com.tencent.cos.xml.crypto.KMSEncryptionMaterials;
import com.tencent.cos.xml.crypto.KMSSecuredCEK;
import com.tencent.cos.xml.crypto.MaterialsDescriptionProvider;
import com.tencent.cos.xml.crypto.ObjectMetadata;
import com.tencent.cos.xml.crypto.QCLOUDKMS;
import com.tencent.cos.xml.crypto.SecuredCEK;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.s3.Base64;
import com.tencentcloudapi.kms.v20190118.models.DecryptRequest;
import com.tencentcloudapi.kms.v20190118.models.DecryptResponse;
import com.tencentcloudapi.kms.v20190118.models.EncryptRequest;
import com.tencentcloudapi.kms.v20190118.models.EncryptResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONException;

final class ContentCryptoMaterial {
    private final String keyWrappingAlgorithm;
    private final CipherLite cipherLite;
    private final Map<String, String> kekMaterialsDescription;
    private final byte[] encryptedCEK;

    ContentCryptoMaterial(Map<String, String> kekMaterialsDescription, byte[] encryptedCEK, String keyWrappingAlgorithm, CipherLite cipherLite) {
        this.cipherLite = cipherLite;
        this.keyWrappingAlgorithm = keyWrappingAlgorithm;
        this.encryptedCEK = (byte[])encryptedCEK.clone();
        this.kekMaterialsDescription = kekMaterialsDescription;
    }

    String getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    private boolean usesKMSKey() {
        return KMSSecuredCEK.isKMSKeyWrapped(this.keyWrappingAlgorithm);
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.cipherLite.getContentCryptoScheme();
    }

    ObjectMetadata toObjectMetadata(ObjectMetadata metadata) throws JSONException {
        String keyWrapAlgo;
        byte[] encryptedCEK = this.getEncryptedCEK();
        metadata.addUserMetadata("x-cos-meta-client-side-encryption-key", Base64.encodeAsString(encryptedCEK));
        byte[] iv = this.cipherLite.getIV();
        metadata.addUserMetadata("x-cos-meta-client-side-encryption-start", Base64.encodeAsString(iv));
        metadata.addUserMetadata("x-cos-meta-client-side-encryption-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme scheme = this.getContentCryptoScheme();
        metadata.addUserMetadata("x-cos-meta-client-side-encryption-cek-alg", scheme.getCipherAlgorithm());
        int tagLen = scheme.getTagLengthInBits();
        if (tagLen > 0) {
            metadata.addUserMetadata("x-cos-tag-len", String.valueOf(tagLen));
        }
        if ((keyWrapAlgo = this.getKeyWrappingAlgorithm()) != null) {
            metadata.addUserMetadata("x-cos-meta-client-side-encryption-wrap-alg", keyWrapAlgo);
        }
        return metadata;
    }

    String toJsonString() throws JSONException {
        String keyWrapAlgo;
        HashMap<String, String> map = new HashMap<String, String>();
        byte[] encryptedCEK = this.getEncryptedCEK();
        map.put("x-cos-meta-client-side-encryption-key", Base64.encodeAsString(encryptedCEK));
        byte[] iv = this.cipherLite.getIV();
        map.put("x-cos-meta-client-side-encryption-start", Base64.encodeAsString(iv));
        map.put("x-cos-meta-client-side-encryption-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme scheme = this.getContentCryptoScheme();
        map.put("x-cos-meta-client-side-encryption-cek-alg", scheme.getCipherAlgorithm());
        int tagLen = scheme.getTagLengthInBits();
        if (tagLen > 0) {
            map.put("x-cos-tag-len", String.valueOf(tagLen));
        }
        if ((keyWrapAlgo = this.getKeyWrappingAlgorithm()) != null) {
            map.put("x-cos-meta-client-side-encryption-wrap-alg", keyWrapAlgo);
        }
        return JSONUtils.toJsonString(map);
    }

    private String kekMaterialDescAsJson() throws JSONException {
        Map<String, String> kekMaterialDesc = this.getKEKMaterialsDescription();
        if (kekMaterialDesc == null) {
            kekMaterialDesc = Collections.emptyMap();
        }
        return JSONUtils.toJsonString(kekMaterialDesc);
    }

    private static Map<String, String> matdescFromJson(String json) throws JSONException {
        Map<String, String> map = JSONUtils.toMap(json);
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    private static SecretKey cek(byte[] cekSecured, String keyWrapAlgo, EncryptionMaterials materials, Provider securityProvider, ContentCryptoScheme contentCryptoScheme, QCLOUDKMS kms) throws CosXmlClientException {
        Key kek;
        if (KMSSecuredCEK.isKMSKeyWrapped(keyWrapAlgo)) {
            return ContentCryptoMaterial.cekByKMS(cekSecured, keyWrapAlgo, materials, contentCryptoScheme, kms);
        }
        if (materials.getKeyPair() != null ? (kek = materials.getKeyPair().getPrivate()) == null : (kek = materials.getSymmetricKey()) == null) {
            throw CosXmlClientException.internalException((String)"Key encrypting key not available");
        }
        try {
            if (keyWrapAlgo != null) {
                Cipher cipher = securityProvider == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, securityProvider);
                cipher.init(4, kek);
                return (SecretKey)cipher.unwrap(cekSecured, keyWrapAlgo, 3);
            }
            Cipher cipher = securityProvider != null ? Cipher.getInstance(kek.getAlgorithm(), securityProvider) : Cipher.getInstance(kek.getAlgorithm());
            cipher.init(2, kek);
            byte[] decryptedSymmetricKeyBytes = cipher.doFinal(cekSecured);
            return new SecretKeySpec(decryptedSymmetricKeyBytes, "AES");
        }
        catch (Exception e2) {
            throw CosXmlClientException.internalException((String)"Unable to decrypt symmetric key from object metadata");
        }
    }

    private static SecretKey cekByKMS(byte[] cekSecured, String keyWrapAlgo, EncryptionMaterials materials, ContentCryptoScheme contentCryptoScheme, QCLOUDKMS kms) throws CosXmlClientException {
        DecryptRequest decryptReq = new DecryptRequest();
        Map<String, String> materialDesc = materials.getMaterialsDescription();
        try {
            decryptReq.setEncryptionContext(JSONUtils.toJsonString(materialDesc));
        }
        catch (JSONException e2) {
            throw CosXmlClientException.internalException((String)"decrypt request set encryption context got json processing exception");
        }
        decryptReq.setCiphertextBlob(new String(cekSecured));
        DecryptResponse decryptRes = kms.decrypt(decryptReq);
        byte[] key = Base64.decode(decryptRes.getPlaintext());
        return new SecretKeySpec(key, contentCryptoScheme.getKeyGeneratorAlgorithm());
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, boolean keyWrapExpected, QCLOUDKMS kms) throws CosXmlClientException, JSONException {
        return ContentCryptoMaterial.fromObjectMetadata0(metadata, kekMaterialAccessor, securityProvider, null, keyWrapExpected, kms);
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, boolean keyWrapExpected, QCLOUDKMS kms) throws CosXmlClientException, JSONException {
        return ContentCryptoMaterial.fromObjectMetadata0(metadata, kekMaterialAccessor, securityProvider, range, keyWrapExpected, kms);
    }

    private static ContentCryptoMaterial fromObjectMetadata0(ObjectMetadata metadata, EncryptionMaterialsAccessor kekMaterialAccessor, Provider securityProvider, long[] range, boolean keyWrapExpected, QCLOUDKMS kms) throws CosXmlClientException, JSONException {
        EncryptionMaterials materials;
        Map<String, String> userMeta = metadata.getUserMetadata();
        String b64key = userMeta.get("x-cos-meta-client-side-encryption-key");
        if (b64key == null && (b64key = userMeta.get("x-cos-meta-client-side-encryption-key")) == null) {
            throw CosXmlClientException.internalException((String)"Content encrypting key not found.");
        }
        byte[] cekWrapped = Base64.decode(b64key);
        byte[] iv = Base64.decode(userMeta.get("x-cos-meta-client-side-encryption-start"));
        if (cekWrapped == null || iv == null) {
            throw CosXmlClientException.internalException((String)"Content encrypting key or IV not found.");
        }
        String matdescStr = userMeta.get("x-cos-meta-client-side-encryption-matdesc");
        String keyWrapAlgo = userMeta.get("x-cos-meta-client-side-encryption-wrap-alg");
        boolean isKMS = KMSSecuredCEK.isKMSKeyWrapped(keyWrapAlgo);
        Map<String, String> core = ContentCryptoMaterial.matdescFromJson(matdescStr);
        if (isKMS) {
            materials = new KMSEncryptionMaterials(core.get("kms_cmk_id"));
            materials.addDescriptions(core);
        } else {
            EncryptionMaterials encryptionMaterials = materials = kekMaterialAccessor == null ? null : kekMaterialAccessor.getEncryptionMaterials(core);
            if (materials == null) {
                throw CosXmlClientException.internalException((String)"Unable to retrieve the client encryption materials");
            }
        }
        String cekAlgo = userMeta.get("x-cos-meta-client-side-encryption-cek-alg");
        boolean isRangeGet = range != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(cekAlgo);
        if (isRangeGet) {
            iv = contentCryptoScheme.adjustIV(iv, range[0]);
        } else {
            String s;
            int tagLenActual;
            int tagLenExpected = contentCryptoScheme.getTagLengthInBits();
            if (tagLenExpected > 0 && tagLenExpected != (tagLenActual = Integer.parseInt(s = userMeta.get("x-cos-tag-len")))) {
                throw CosXmlClientException.internalException((String)("Unsupported tag length: " + tagLenActual + ", expected: " + tagLenExpected));
            }
        }
        if (keyWrapExpected && keyWrapAlgo == null) {
            throw ContentCryptoMaterial.newKeyWrapException();
        }
        SecretKey cek = ContentCryptoMaterial.cek(cekWrapped, keyWrapAlgo, materials, securityProvider, contentCryptoScheme, kms);
        return new ContentCryptoMaterial(core, cekWrapped, keyWrapAlgo, contentCryptoScheme.createCipherLite(cek, iv, 2, securityProvider));
    }

    private static CosXmlClientException newKeyWrapException() throws CosXmlClientException {
        return CosXmlClientException.internalException((String)"Missing key-wrap for the content-encrypting-key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuilder.toString();
    }

    public CipherLite getCipherLite() {
        return this.cipherLite;
    }

    Map<String, String> getKEKMaterialsDescription() {
        return this.kekMaterialsDescription;
    }

    byte[] getEncryptedCEK() {
        return (byte[])this.encryptedCEK.clone();
    }

    ContentCryptoMaterial recreate(Map<String, String> newKEKMatDesc, EncryptionMaterialsAccessor accessor, COSCryptoScheme targetScheme, Provider p, QCLOUDKMS kms, CosXmlRequest req) throws CosXmlClientException {
        EncryptionMaterials origKEK;
        if (!this.usesKMSKey() && newKEKMatDesc.equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        if (this.usesKMSKey()) {
            origKEK = new KMSEncryptionMaterials(this.kekMaterialsDescription.get("kms_cmk_id"));
        } else {
            origKEK = accessor.getEncryptionMaterials(this.kekMaterialsDescription);
            if (origKEK == null) {
                throw CosXmlClientException.internalException((String)"Unable to retrieve the origin encryption materials");
            }
        }
        EncryptionMaterials newKEK = accessor.getEncryptionMaterials(newKEKMatDesc);
        if (newKEK == null) {
            throw CosXmlClientException.internalException((String)("No material available with the description " + newKEKMatDesc + " from the encryption material provider"));
        }
        SecretKey cek = ContentCryptoMaterial.cek(this.encryptedCEK, this.keyWrappingAlgorithm, origKEK, p, this.getContentCryptoScheme(), kms);
        ContentCryptoMaterial output = ContentCryptoMaterial.create(cek, this.cipherLite.getIV(), newKEK, this.getContentCryptoScheme(), targetScheme, p, kms, req);
        if (Arrays.equals(output.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return output;
    }

    ContentCryptoMaterial recreate(EncryptionMaterials newKEK, EncryptionMaterialsAccessor accessor, COSCryptoScheme targetScheme, Provider p, QCLOUDKMS kms, CosXmlRequest req) throws CosXmlClientException {
        EncryptionMaterials origKEK;
        if (!this.usesKMSKey() && newKEK.getMaterialsDescription().equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        if (this.usesKMSKey()) {
            origKEK = new KMSEncryptionMaterials(this.kekMaterialsDescription.get("kms_cmk_id"));
        } else {
            origKEK = accessor.getEncryptionMaterials(this.kekMaterialsDescription);
            if (origKEK == null) {
                throw CosXmlClientException.internalException((String)"Unable to retrieve the origin encryption materials");
            }
        }
        SecretKey cek = ContentCryptoMaterial.cek(this.encryptedCEK, this.keyWrappingAlgorithm, origKEK, p, this.getContentCryptoScheme(), kms);
        ContentCryptoMaterial output = ContentCryptoMaterial.create(cek, this.cipherLite.getIV(), newKEK, this.getContentCryptoScheme(), targetScheme, p, kms, req);
        if (Arrays.equals(output.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return output;
    }

    static ContentCryptoMaterial create(SecretKey cek, byte[] iv, EncryptionMaterials kekMaterials, ContentCryptoScheme contentCryptoScheme, COSCryptoScheme targetScheme, Provider provider, QCLOUDKMS kms, CosXmlRequest req) throws CosXmlClientException {
        return ContentCryptoMaterial.doCreate(cek, iv, kekMaterials, contentCryptoScheme, targetScheme, provider, kms, req);
    }

    static ContentCryptoMaterial create(SecretKey cek, byte[] iv, EncryptionMaterials kekMaterials, COSCryptoScheme scheme, Provider provider, QCLOUDKMS kms, CosXmlRequest req) throws CosXmlClientException {
        return ContentCryptoMaterial.doCreate(cek, iv, kekMaterials, scheme.getContentCryptoScheme(), scheme, provider, kms, req);
    }

    private static ContentCryptoMaterial doCreate(SecretKey cek, byte[] iv, EncryptionMaterials kekMaterials, ContentCryptoScheme contentCryptoScheme, COSCryptoScheme targetCOSCryptoScheme, Provider provider, QCLOUDKMS kms, CosXmlRequest req) throws CosXmlClientException {
        SecuredCEK cekSecured = ContentCryptoMaterial.secureCEK(cek, kekMaterials, targetCOSCryptoScheme.getKeyWrapScheme(), targetCOSCryptoScheme.getSecureRandom(), provider, kms, req);
        return ContentCryptoMaterial.wrap(cek, iv, contentCryptoScheme, provider, cekSecured);
    }

    public static ContentCryptoMaterial wrap(SecretKey cek, byte[] iv, ContentCryptoScheme contentCryptoScheme, Provider provider, SecuredCEK cekSecured) throws CosXmlClientException {
        return new ContentCryptoMaterial(cekSecured.getMaterialDescription(), cekSecured.getEncrypted(), cekSecured.getKeyWrapAlgorithm(), contentCryptoScheme.createCipherLite(cek, iv, 1, provider));
    }

    private static SecuredCEK secureCEK(SecretKey cek, EncryptionMaterials materials, COSKeyWrapScheme kwScheme, SecureRandom srand, Provider p, QCLOUDKMS kms, CosXmlRequest req) throws CosXmlClientException {
        if (materials.isKMSEnabled()) {
            Map<String, String> matdesc = ContentCryptoMaterial.mergeMaterialDescriptions(materials, req);
            EncryptRequest encryptRequest = new EncryptRequest();
            try {
                encryptRequest.setEncryptionContext(JSONUtils.toJsonString(matdesc));
            }
            catch (JSONException e2) {
                throw CosXmlClientException.internalException((String)"encrypt request set encryption context got json processing exception");
            }
            encryptRequest.setKeyId(materials.getCustomerMasterKeyId());
            encryptRequest.setPlaintext(cek.getEncoded().toString());
            EncryptResponse encryptResponse = kms.encrypt(encryptRequest);
            byte[] keyBlob = encryptResponse.getCiphertextBlob().getBytes();
            return new KMSSecuredCEK(keyBlob, matdesc);
        }
        Map<String, String> matdesc = materials.getMaterialsDescription();
        Key kek = materials.getKeyPair() != null ? materials.getKeyPair().getPublic() : materials.getSymmetricKey();
        String keyWrapAlgo = kwScheme.getKeyWrapAlgorithm(kek);
        try {
            Cipher cipher = p == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, p);
            cipher.init(3, kek, srand);
            return new SecuredCEK(cipher.wrap(cek), keyWrapAlgo, matdesc);
        }
        catch (Exception e3) {
            throw CosXmlClientException.internalException((String)"Unable to encrypt symmetric key");
        }
    }

    static Map<String, String> mergeMaterialDescriptions(EncryptionMaterials materials, CosXmlRequest req) {
        MaterialsDescriptionProvider mdp;
        Map<String, String> matdesc_req;
        Map<String, String> matdesc = materials.getMaterialsDescription();
        if (req instanceof MaterialsDescriptionProvider && (matdesc_req = (mdp = (MaterialsDescriptionProvider)req).getMaterialsDescription()) != null) {
            matdesc = new TreeMap<String, String>(matdesc);
            matdesc.putAll(matdesc_req);
        }
        return matdesc;
    }
}

