package org.qas.qtest.api.services.user.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.user.model.User;

/**
 * UserJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id UserJsonUnmarshaller 2014-07-10 09:40:30z dungvnguyen $
 * @since 1.0
 */
public class UserJsonUnmarshaller extends AbstractUnmarshaller<User, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static UserJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static UserJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new UserJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public User parse(String data) throws Exception {
    return JsonMapper.parseJson(data, User.class);
  }
}
