package org.qas.qtest.api.services.user.model.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.user.model.User;

import java.util.List;

/**
 * AssigneeJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id AssigneeJsonUnmarshaller 2014-07-10 10:41:30z dungvnguyen $
 * @since 1.0
 */
public class ListUserJsonUnmarshaller extends AbstractUnmarshaller<List<User>, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static ListUserJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static ListUserJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new ListUserJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public List<User> parse(String data) throws Exception {
    return JsonMapper.parseJson(data, new TypeReference<List<User>>() {
    });
  }
}
