package org.qas.qtest.api.services.user.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.qas.qtest.api.internal.model.QTestBaseModel;

/**
 * User
 *
 * @author Dzung Nguyen
 * @version $Id User 2014-07-09 14:33:30z dungvnguyen $
 * @since 1.0
 */
public class User extends QTestBaseModel<User> {
  @JsonProperty("id")
  private Long id;

  @JsonProperty("user_name")
  private String username;

  @JsonProperty("email")
  private String email;

  @JsonProperty("first_name")
  private String firstName;

  @JsonProperty("last_name")
  private String lastName;

  @JsonProperty("client_id")
  private Long clientId;

  @JsonProperty("client_name")
  private String clientName;

  @JsonProperty("client_site")
  private String clientSite;

  @JsonProperty("timezone_offset")
  private String timezoneOffset;

  public User() {
  }

  /**
   * @return the user identifier.
   */
  public Long getId() {
    return id;
  }

  /**
   * Sets the user identifier.
   *
   * @param id the given requirement identifier.
   */
  public User setId(Long id) {
    this.id = id;
    return this;
  }

  /**
   * Sets the user identifier and return itself.
   *
   * @param id the given user identifier value to set.
   * @return the user instance.
   */
  public User withId(Long id) {
    setId(id);
    return this;
  }

  /**
   * @return the user name.
   */
  public String getUsername() {
    return username;
  }

  /**
   * Sets the user name.
   *
   * @param username the given user name to set.
   */
  public User setUsername(String username) {
    this.username = username;
    return this;
  }

  /**
   * Sets the user name and return current instance.
   *
   * @param username the given user name to set.
   * @return the current user instance.
   */
  public User withUsername(String username) {
    setUsername(username);
    return this;
  }

  /**
   * @return the user contact mail.
   */
  public String getEmail() {
    return email;
  }

  /**
   * Sets the user contact mail.
   *
   * @param email the given user contact mail to set.
   */
  public User setEmail(String email) {
    this.email = email;
    return this;
  }

  /**
   * Sets the user contact mail and current user instance.
   *
   * @param email the given user contact mail to set.
   * @return current user instance.
   */
  public User withEmail(String email) {
    setEmail(email);
    return this;
  }

  /**
   * @return the user first name.
   */
  public String getFirstName() {
    return firstName;
  }

  /**
   * Sets the user first name.
   *
   * @param firstName the given user first name to set.
   */
  public User setFirstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

  /**
   * Sets the user first name.
   *
   * @param firstName the given user first name to set.
   * @return the current user instance.
   */
  public User withFirstName(String firstName) {
    setFirstName(firstName);
    return this;
  }

  /**
   * @return the user last name.
   */
  public String getLastName() {
    return lastName;
  }

  /**
   * Sets the user last name.
   *
   * @param lastName the given user last name.
   */
  public User setLastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

  /**
   * Sets the user last name.
   *
   * @param lastName the given user last name to set.
   * @return the current user instance.
   */
  public User withLastName(String lastName) {
    setLastName(lastName);
    return this;
  }

  /**
   * @return the client identifier.
   */
  public Long getClientId() {
    return clientId;
  }

  /**
   * Sets the client identifier.
   *
   * @param clientId the given client identifier to set.
   */
  public User setClientId(Long clientId) {
    this.clientId = clientId;
    return this;
  }

  /**
   * Sets the client identifier and return user instance.
   *
   * @param clientId the given client identifier to set.
   * @return the current user instance.
   */
  public User withClientId(Long clientId) {
    setClientId(clientId);
    return this;
  }

  /**
   * @return the client name.
   */
  public String getClientName() {
    return clientName;
  }

  /**
   * Sets the client name.
   *
   * @param clientName the given client name to set.
   */
  public User setClientName(String clientName) {
    this.clientName = clientName;
    return this;
  }

  /**
   * Sets the client name and return the current instance.
   *
   * @param clientName the givne client name to set.
   * @return the current instance.
   */
  public User withClientName(String clientName) {
    setClientName(clientName);
    return this;
  }

  /**
   * @return the client site.
   */
  public String getClientSite() {
    return clientSite;
  }

  /**
   * Sets the client site.
   *
   * @param clientSite the given client site value to set.
   */
  public User setClientSite(String clientSite) {
    this.clientSite = clientSite;
    return this;
  }

  /**
   * Sets the client site and return user instance.
   *
   * @param clientSite the given client site value to set.
   * @return the current user instance.
   */
  public User withClientSite(String clientSite) {
    setClientSite(clientSite);
    return this;
  }

  /**
   * @return the user timezone offset.
   */
  public String getTimezoneOffset() {
    return timezoneOffset;
  }

  /**
   * Sets the timezone offset of the current user.
   *
   * @param timezoneOffset the given timezone offset.
   */
  public User setTimezoneOffset(String timezoneOffset) {
    this.timezoneOffset = timezoneOffset;
    return this;
  }

  /**
   * Sets the timezone offset of the current user.
   *
   * @param timezoneOffset the given user's timezone offset.
   * @return the current instance.
   */
  public User withTimezoneOffset(String timezoneOffset) {
    setTimezoneOffset(timezoneOffset);
    return this;
  }

  @Override
  public User clone() {
    User that = new User();
    that.setPropertiesFrom(this);
    return that;
  }

  @Override
  public String elementName() {
    return "user";
  }
}
