package org.qas.qtest.api.services.user.model;

import org.qas.qtest.api.internal.model.QTestBaseModel;

/**
 * Profile
 *
 * @author Dzung Nguyen
 * @version $Id Profile 2014-07-10 15:11:30z dungvnguyen $
 * @since 1.0
 */
public class Profile extends QTestBaseModel<Profile> {
  private Long id;
  private String name;

  /**
   * Constructs {@link Profile} object.
   */
  public Profile() {
  }

  /**
   * @return the profile identifier.
   */
  public Long getId() {
    return id;
  }

  /**
   * Sets profile identifier.
   *
   * @param id the given profile identifier to set.
   */
  public Profile setId(Long id) {
    this.id = id;
    return this;
  }

  /**
   * Sets profile identifier.
   *
   * @param id the given profile identifier to set.
   * @return current profile instance.
   */
  public Profile withid(Long id) {
    setId(id);
    return this;
  }

  /**
   * @return the profile name.
   */
  public String getName() {
    return name;
  }

  /**
   * Sets profile name.
   *
   * @param name the given profile name to set.
   */
  public Profile setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Sets the profile name.
   *
   * @param name the given profile name to set.
   * @return the current profile instance.
   */
  public Profile withName(String name) {
    setName(name);
    return this;
  }

  @Override
  public Profile clone() {
    Profile that = new Profile();

    // copy current property.
    that.setPropertiesFrom(this);

    return that;
  }

  @Override
  public String elementName() {
    return "profile";
  }
}
