package org.qas.qtest.api.services.user.model;

import org.qas.api.ApiServiceRequest;

import java.util.List;

/**
 * AssignUserRequest
 *
 * @author Dzung Nguyen
 * @version $Id AssignUserRequest 2014-07-10 14:49:30z dungvnguyen $
 * @since 1.0
 */
public class AssignToProjectRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private List<Long> userIds;
  private Long projectId;
  private Long adminProfileId;
  private Long userProfileId;

  //~ class members ===========================================================

  /**
   * @return the list of user identifiers.
   */
  public List<Long> getUserIds() {
    return userIds;
  }

  /**
   * Sets the list of user identifiers.
   *
   * @param userIds the given user identifier to set.
   */
  public void setUserIds(List<Long> userIds) {
    this.userIds = userIds;
  }

  /**
   * Sets the list of user identifiers.
   *
   * @param userIds the given list of user identifiers to set.
   * @return current instance.
   */
  public AssignToProjectRequest withUserIds(List<Long> userIds) {
    setUserIds(userIds);
    return this;
  }

  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the current instance.
   */
  public AssignToProjectRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return
   */
  public Long getAdminProfileId() {
    return adminProfileId;
  }

  /**
   * @param adminProfileId
   * @return
   */
  public AssignToProjectRequest setAdminProfileId(Long adminProfileId) {
    this.adminProfileId = adminProfileId;
    return this;
  }

  /**
   * @param adminProfileId
   * @return
   */
  public AssignToProjectRequest withAdminProfileId(Long adminProfileId) {
    this.adminProfileId = adminProfileId;
    return this;
  }

  /**
   * @return
   */
  public Long getUserProfileId() {
    return userProfileId;
  }

  /**
   * @param userProfileId
   * @return
   */
  public AssignToProjectRequest setUserProfileId(Long userProfileId) {
    this.userProfileId = userProfileId;
    return this;
  }

  /**
   * @param userProfileId
   * @return
   */
  public AssignToProjectRequest withUserProfileId(Long userProfileId) {
    this.userProfileId = userProfileId;
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("AssignToProjectRequest{\n");
    sb.append("\tuserIds: ").append(userIds).append(",\n");
    sb.append("\tprojectId: ").append(projectId).append("\n");
    sb.append("\tadminProfileId: ").append(adminProfileId).append("\n");
    sb.append("\tuserProfileId: ").append(userProfileId).append("\n");
    sb.append('}');
    return sb.toString();
  }
}
