package org.qas.qtest.api.services.search.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.defect.model.Defect;
import org.qas.qtest.api.services.design.model.TestCase;
import org.qas.qtest.api.services.execution.model.TestCycle;
import org.qas.qtest.api.services.execution.model.TestRun;
import org.qas.qtest.api.services.execution.model.TestSuite;
import org.qas.qtest.api.services.plan.model.Build;
import org.qas.qtest.api.services.plan.model.Release;
import org.qas.qtest.api.services.requirement.model.Requirement;
import org.qas.qtest.api.services.search.model.ArtifactSearchType;
import org.qas.qtest.api.services.search.model.SearchResult;

/**
 * @author trongle
 * @since 1.4.9
 */
public class SearchArtifactUnmarshaller extends AbstractUnmarshaller<SearchResult, JsonUnmarshallerContext> {
  private ArtifactSearchType searchType;
  
  public SearchArtifactUnmarshaller(ArtifactSearchType searchType) {
    this.searchType = searchType;
  }
  
  @Override
  public SearchResult parse(String data) throws Exception {
    if (ArtifactSearchType.Release.equals(searchType)) {
      return JsonMapper.fromJson(data, new TypeReference<SearchResult<Release>>() {
      });
    } else if (ArtifactSearchType.Build.equals(searchType)) {
      return JsonMapper.fromJson(data, new TypeReference<SearchResult<Build>>() {
      });
    } else if (ArtifactSearchType.Requirement.equals(searchType)) {
      return JsonMapper.fromJson(data, new TypeReference<SearchResult<Requirement>>() {
      });
    } else if (ArtifactSearchType.TestCycle.equals(searchType)) {
      return JsonMapper.fromJson(data, new TypeReference<SearchResult<TestCycle>>() {
      });
    } else if (ArtifactSearchType.TestSuite.equals(searchType)) {
      return JsonMapper.fromJson(data, new TypeReference<SearchResult<TestSuite>>() {
      });
    } else if (ArtifactSearchType.TestCase.equals(searchType)) {
      return JsonMapper.fromJson(data, new TypeReference<SearchResult<TestCase>>() {
      });
    } else if (ArtifactSearchType.TestRun.equals(searchType)) {
      return JsonMapper.fromJson(data, new TypeReference<SearchResult<TestRun>>() {
      });
    } else if (ArtifactSearchType.Defect.equals(searchType)) {
      return JsonMapper.fromJson(data, new TypeReference<SearchResult<Defect>>() {
      });
    } else {
      return JsonMapper.fromJson(data, new TypeReference<SearchResult>() {
      });
    }
  }
}
