package org.qas.qtest.api.services.search.model;

import org.qas.qtest.api.internal.model.ObjectType;
import org.qas.qtest.api.services.common.PagingRequest;

import java.util.Date;
import java.util.List;

/**
 * @author trongle
 * @since 1.4.9
 */
public final class SearchCommentRequest extends PagingRequest<SearchCommentRequest> {
  private Date start;
  private Date end;
  private List<String> fields;
  private long objectId;
  private long authorId;
  private CommentSearchType searchType;
  
  public SearchCommentRequest(CommentSearchType searchType) {
    if (null == searchType) {
      throw new IllegalArgumentException("invalid search type");
    }
    this.searchType = searchType;
  }
  
  public List<String> getFields() {
    return fields;
  }
  
  public SearchCommentRequest setFields(List<String> fields) {
    this.fields = fields;
    return this;
  }
  
  public Date getStart() {
    return start;
  }
  
  public SearchCommentRequest setStart(Date start) {
    this.start = start;
    return this;
  }
  
  public Date getEnd() {
    return end;
  }
  
  public SearchCommentRequest setEnd(Date end) {
    this.end = end;
    return this;
  }
  
  public long getObjectId() {
    return objectId;
  }
  
  public SearchCommentRequest setObjectId(long objectId) {
    this.objectId = objectId;
    return this;
  }
  
  public long getAuthorId() {
    return authorId;
  }
  
  public SearchCommentRequest setAuthorId(long authorId) {
    this.authorId = authorId;
    return this;
  }
  
  public ObjectType getObjectType() {
    return searchType.getObjectType();
  }
}
