package org.qas.qtest.api.services.requirement.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.requirement.model.GetRequirementFieldsRequest;

/**
 * GetRequirementFieldsRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id GetRequirementFieldsRequestMarshaller 2014-05-19 11:11:30z dungvnguyen $
 * @since 1.0
 */
public class GetRequirementFieldsRequestMarshaller extends AbstractMarshaller<Request, GetRequirementFieldsRequest> {

  @Override
  protected void validateRequest(GetRequirementFieldsRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to call(...)");
    }

    if (in.getProjectId() == null || in.getProjectId() <= 0L) {
      throw new AuthClientException("Invalid project identifier passed to call(...)");
    }
  }

  @Override
  protected String getServiceName() {
    return "RequirementService";
  }

  @Override
  protected String getActionName() {
    return "GetRequirementFields";
  }

  @Override
  protected String getContent(GetRequirementFieldsRequest in) throws Exception {
    return null;
  }

  @Override
  protected StringBuilder getResourcePath(GetRequirementFieldsRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId())
      .append("/settings/requirements/fields");
  }
}
