package org.qas.qtest.api.services.requirement.model;

import org.qas.api.ApiServiceRequest;

/**
 * GetRequirementFieldsRequest
 *
 * @author Dzung Nguyen
 * @version $Id GetRequirementFieldsRequest 2014-05-19 11:09:30z dungvnguyen $
 * @since 1.0
 */
public class GetRequirementFieldsRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;

  //~ class members ===========================================================
  /**
   * @return the project identifier that the requirement will attach to.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier value to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the project identifier and return itself.
   *
   * @param projectId the given project identifier value to set.
   * @return the create requirement request instance.
   */
  public GetRequirementFieldsRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder(getClass().getName());

    builder.append("{").append("\n")
        .append("\tprojectId: ").append(projectId).append(",").append("\n")
        .append("}");

    return builder.toString();
  }
}
