package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.project.model.UserPermissions;

/**
 * UserPermissionsJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id UserPermissionsJsonUnmarshaller 2014-11-07 12:19:30z dungvnguyen $
 * @since 1.0
 */
public final class UserPermissionsJsonUnmarshaller extends AbstractUnmarshaller<UserPermissions, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static UserPermissionsJsonUnmarshaller instance;

  //~ class members ===========================================================

  /**
   * @return the current {@link UserPermissionsJsonUnmarshaller} instance.
   */
  public static UserPermissionsJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new UserPermissionsJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public UserPermissions parse(String data) throws Exception {
    return JsonMapper.parseJson(data, UserPermissions.class);
  }
}
