package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.project.model.UpdateModuleRequest;

/**
 * UpdateModuleRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id UpdateModuleRequestMarshaller 2015-06-01 16:45:30z dzungvnguyen $
 * @since 1.0
 */
public final class UpdateModuleRequestMarshaller
  extends AbstractModuleRequestMarshaller<UpdateModuleRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(UpdateModuleRequest moduleRequest) throws Exception {
    // validate request.
    moduleRequest = ApiPreconditions.notNull(moduleRequest);
    validateProjectId(moduleRequest.getProjectId());
    ApiPreconditions.notNull(moduleRequest.getModule(), "Invalid module passed to marshall(...)");
    validateModuleId(moduleRequest.getModule().getId());

    // create module request.
    Request request = createJsonRequest(moduleRequest, "UpdateModule", HttpMethod.PUT);

    // build path.
    StringBuilder pathBuilder = createApiPathBuilder(moduleRequest.getProjectId());
    pathBuilder.append("/").append(moduleRequest.getModule().getId());
    request.setResourcePath(pathBuilder.toString());

    // set request payload.
    request.setContent(new StringInputStream(JsonMapper.toJson(moduleRequest.getModule())));

    // return request.
    return request;
  }
}
