package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.project.model.SearchModuleRequest;

/**
 * SearchModuleRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id SearchModuleRequestMarshaller 2015-06-01 17:37:30z dzungvnguyen $
 * @since 1.0
 */
public final class SearchModuleRequestMarshaller
  extends AbstractModuleRequestMarshaller<SearchModuleRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(SearchModuleRequest moduleRequest) throws Exception {
    // validate module.
    moduleRequest = ApiPreconditions.notNull(moduleRequest);
    validateProjectId(moduleRequest.getProjectId());
    ApiPreconditions.checkArgument(
      moduleRequest.getParentId() == null || moduleRequest.getParentId().longValue() > 0L,
      "Invalid parent module identifier passed to marshall(...)"
    );
    ApiPreconditions.checkArgument(
      moduleRequest.getQuery() != null && moduleRequest.getQuery().trim().length() > 0,
      "Invalid query parameter passed to marshall(...)"
    );

    // create request.
    Request request = createJsonRequest(moduleRequest, "SearchModule", HttpMethod.GET);
    request.setResourcePath(createApiPathBuilder(moduleRequest.getProjectId()).toString());

    // set query parameter.
    if (moduleRequest.getParentId() != null) {
      request.addParameter("parentId", String.valueOf(moduleRequest.getParentId().longValue()));
    }

    // include descendants?
    if (moduleRequest.isIncludeDescendants()) {
      request.addParameter("expand", "descendants");
    }

    // set query parameter.
    request.addParameter("search", moduleRequest.getQuery().trim());

    return request;
  }
}
