package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.project.model.Project;

/**
 * ProjectJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ProjectJsonUnmarshaller 2014-03-27 17:52:30z dungvnguyen $
 * @since 1.0
 */
public final class ProjectJsonUnmarshaller extends AbstractUnmarshaller<Project, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static ProjectJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static ProjectJsonUnmarshaller getInstance() {
    if (instance == null) instance = new ProjectJsonUnmarshaller();
    return instance;
  }

  @Override
  public Project parse(String data) throws Exception {
    return JsonMapper.fromJson(data, Project.class);
  }
}
