package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.project.model.MoveModuleRequest;

/**
 * MoveModuleRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id MoveModuleRequestMarshaller 2015-06-01 17:09:30z dzungvnguyen $
 * @since 1.0
 */
public final class MoveModuleRequestMarshaller
  extends AbstractModuleRequestMarshaller<MoveModuleRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(MoveModuleRequest moduleRequest) throws Exception {
    // validate module.
    moduleRequest = ApiPreconditions.notNull(moduleRequest);
    validateProjectId(moduleRequest.getProjectId());
    validateModuleId(moduleRequest.getModuleId());
    ApiPreconditions.checkArgument(
      (moduleRequest.getParentId() == null || moduleRequest.getParentId().longValue() > 0L),
      "Invalid parent identifier passed to marshall(...)"
    );

    // create request.
    Request request = createJsonRequest(moduleRequest, "MoveModule", HttpMethod.PUT);

    // create path builder.
    StringBuilder pathBuilder = createApiPathBuilder(moduleRequest.getProjectId());
    pathBuilder.append("/").append(moduleRequest.getModuleId());
    request.setResourcePath(pathBuilder.toString());

    // set parameters.
    if (moduleRequest.getParentId() != null) {
      request.addParameter("parentId", String.valueOf(moduleRequest.getModuleId().longValue()));
    }

    request.setContent(new StringInputStream("{}"));
    return request;
  }
}
