package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.project.model.Module;

/**
 * ModuleJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ModuleJsonUnmarshaller 2014-05-17 12:16:30z dungvnguyen $
 * @since 1.0
 */
public final class ModuleJsonUnmarshaller extends AbstractUnmarshaller<Module, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static ModuleJsonUnmarshaller instance;

  //~ class members ===========================================================

  /**
   * @return the {@link ModuleJsonUnmarshaller} instance.
   */
  public static ModuleJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new ModuleJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public Module parse(String data) throws Exception {
    return JsonMapper.parseJson(data, Module.class);
  }
}
