package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.project.model.ListModuleRequest;

/**
 * ListModuleRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListModuleRequestMarshaller 2015-01-16 15:54:30z dzungvnguyen $
 * @since 1.0
 */
public final class ListModuleRequestMarshaller extends AbstractModuleRequestMarshaller<ListModuleRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(ListModuleRequest listModuleRequest) throws Exception {
    // validate list module request.
    listModuleRequest = ApiPreconditions.notNull(listModuleRequest);
    validateProjectId(listModuleRequest.getProjectId());

    // create list module request.
    Request request = createJsonRequest(listModuleRequest, "ListModule", HttpMethod.GET);

    // set request parameter.
    if (listModuleRequest.isIncludeDescendants()) {
      request.addParameter("expand", "descendants");
    }

    // set parent identifier.
    if (listModuleRequest.getParentModuleId() != null
        && listModuleRequest.getParentModuleId().longValue() > 0) {
      request.addParameter("parentId", listModuleRequest.getParentModuleId().toString());
    }

    // set resource path.
    request.setResourcePath(createApiPathBuilder(listModuleRequest.getProjectId().longValue()).toString());

    // return the request.
    return request;
  }
}
