package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.project.model.GetFieldsRequest;

/**
 * GetFieldsRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id GetFieldsRequestMarshaller 2014-07-14 21:51:30z dungvnguyen $
 * @since 1.0
 */
public final class GetFieldsRequestMarshaller extends AbstractMarshaller<Request, GetFieldsRequest> {

  @Override
  protected void validateRequest(GetFieldsRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid request passed to call(...)");
    }

    if (in.getProjectId() == null || in.getProjectId() <= 0) {
      throw new AuthClientException("Invalid project identifier passed to call(...)");
    }

    if (in.getObjectType() == null) {
      throw new AuthClientException("Invalid objectQTestProjectConnectorQTestProjectConnector type passed to call(...)");
    }
  }

  @Override
  protected String getServiceName() {
    return "ProjectService";
  }

  @Override
  protected String getActionName() {
    return "GetFields";
  }

  @Override
  protected String getContent(GetFieldsRequest in) {
    return null;
  }

  @Override
  protected StringBuilder getResourcePath(GetFieldsRequest in, StringBuilder rpBuilder) {
    rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId().longValue())
      .append("/settings/")
      .append(in.getObjectType().getPath())
      .append("/fields");
    if (in.isIncludeInactive()) {
      rpBuilder.append("?includeInactive=true");
    }
    return rpBuilder;
  }
}
