package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.project.model.DeleteModuleRequest;

/**
 * DeleteModuleRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id DeleteModuleRequestMarshaller 2015-06-01 17:23:30z dzungvnguyen $
 * @since 1.0
 */
public final class DeleteModuleRequestMarshaller
  extends AbstractModuleRequestMarshaller<DeleteModuleRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(DeleteModuleRequest moduleRequest) throws Exception {
    // validate module request.
    moduleRequest = ApiPreconditions.notNull(moduleRequest);
    validateProjectId(moduleRequest.getProjectId());
    validateModuleId(moduleRequest.getModuleId());

    // create request.
    Request request = createJsonRequest(moduleRequest, "DeleteModule", HttpMethod.DELETE);

    // create request resource path.
    StringBuilder pathBuilder = createApiPathBuilder(moduleRequest.getProjectId());
    pathBuilder.append("/").append(moduleRequest.getModuleId());
    request.setResourcePath(pathBuilder.toString());

    // set parameter.
    if (moduleRequest.isForce()) {
      request.addParameter("force", "true");
    }

    return request;
  }
}
