package org.qas.qtest.api.services.project.model;

import org.qas.api.ApiServiceRequest;

import java.util.ArrayList;
import java.util.List;

/**
 * LinkTestCaseRequirementRequest
 *
 * @author Dzung Nguyen
 * @version $Id LinkTestCaseRequirementRequest 2014-05-19 15:49:30z dungvnguyen $
 * @since 1.0
 */
public final class LinkTestCaseRequirementRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private Long requirementId;
  private List<Long> testCaseIds;

  //~ class members ===========================================================

  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return current instance.
   */
  public LinkTestCaseRequirementRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the requirement identifier.
   */
  public Long getRequirementId() {
    return this.requirementId;
  }

  /**
   * Sets the requirement identifier.
   *
   * @param requirementId the given requirement identifier.
   */
  public void setRequirementId(Long requirementId) {
    this.requirementId = requirementId;
  }

  /**
   * Sets the requirement identifier.
   *
   * @param requirementId the given requirement identifier.
   * @return current instance.
   */
  public LinkTestCaseRequirementRequest withRequirementId(Long requirementId) {
    setRequirementId(requirementId);
    return this;
  }

  /**
   * @return the list of testcase identifiers.
   */
  public List<Long> getTestCaseIds() {
    return this.testCaseIds;
  }

  /**
   * Sets the list of test-case identifiers.
   *
   * @param testCaseIds the given list of test-case identifiers.
   */
  public void setTestCaseIds(List<Long> testCaseIds) {
    this.testCaseIds = testCaseIds;
  }

  /**
   * Sets the list of test-case identifiers.
   *
   * @param testCaseIds the given list of test-case identifiers.
   * @return current instance.
   */
  public LinkTestCaseRequirementRequest withTestCaseIds(List<Long> testCaseIds) {
    this.setTestCaseIds(testCaseIds);
    return this;
  }

  /**
   * Adds the test case identifier to request.
   *
   * @param testCaseId the given testcase identifier.
   * @return the current instance.
   */
  public LinkTestCaseRequirementRequest addTestCaseId(Long testCaseId) {
    if (this.testCaseIds == null) {
      this.testCaseIds = new ArrayList<>();
    }

    this.testCaseIds.add(testCaseId);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder(getClass().getName());

    builder.append("{").append("\n")
      .append("\tprojectId: ").append(projectId).append(", \n")
      .append("\trequirementId: ").append(requirementId).append(", \n")
      .append("\ntestCaseIds: ").append(testCaseIds).append("\n")
      .append("}");

    return builder.toString();
  }
}
