package org.qas.qtest.api.services.project.model;

import org.qas.api.ApiServiceRequest;

/**
 * GetUserPermissionsRequest
 *
 * @author Dzung Nguyen
 * @version $Id GetUserPermissionsRequest 2014-11-07 12:46:30z dungvnguyen $
 * @since 1.0
 */
public final class GetUserPermissionsRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;

  //~ class members ===========================================================
  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the current request instance.
   */
  public GetUserPermissionsRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("GetUserPermissionsRequest{\n");
    sb.append("\tprojectId: ").append(projectId).append("\n");
    sb.append('}');
    return sb.toString();
  }
}
