package org.qas.qtest.api.services.project.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * GetModuleRequest
 *
 * @author Dzung Nguyen
 * @version $Id GetModuleRequest 2015-01-16 13:34:30z dzungvnguyen $
 * @since 1.0
 */
public final class GetModuleRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long moduleId;
  private boolean includeDescendants = false;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the project identifier to set.
   */
  public GetModuleRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the module identifier.
   */
  public Long getModuleId() {
    return moduleId;
  }

  /**
   * Sets the module identifier.
   *
   * @param moduleId the given module identifier to set.
   */
  public void setModuleId(Long moduleId) {
    this.moduleId = moduleId;
  }

  /**
   * Sets the module identifier.
   *
   * @param moduleId the given module identifier to set.
   * @return current instance.
   */
  public GetModuleRequest withModuleId(Long moduleId) {
    setModuleId(moduleId);
    return this;
  }

  /**
   * @return include descendants flag.
   */
  public boolean isIncludeDescendants() {
    return includeDescendants;
  }

  /**
   * Sets the include descendants flag.
   *
   * @param includeDescendants the given include descendants flag to set.
   */
  public void setIncludeDescendants(boolean includeDescendants) {
    this.includeDescendants = includeDescendants;
  }

  /**
   * Sets the include descendants flag.
   *
   * @param includeDescendants the given include descendants flag to set.
   * @return current {@link GetModuleRequest get module request} instance.
   */
  public GetModuleRequest withIncludeDescendants(boolean includeDescendants) {
    setIncludeDescendants(includeDescendants);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder(this.getClass().getName());

    builder.append("{").append("\n")
        .append("\t").append("projectId: ").append(projectId).append(",").append("\n")
        .append("\t").append("moduleId: ").append(moduleId).append(",").append("\n")
        .append("\t").append("includeDescendant: ").append(includeDescendants).append("\n")
        .append("}");

    return builder.toString();
  }
}
