package org.qas.qtest.api.services.project.model;

import org.qas.api.ApiServiceRequest;

/**
 * CreateProjectRequest
 *
 * @author Dzung Nguyen
 * @version $Id CreateProjectRequest 2014-05-16 15:06:30z dungvnguyen $
 * @since 1.0
 */
public final class CreateProjectRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Project project;

  //~ class members ===========================================================
  /**
   * @return the current {@link Project project} information to create.
   */
  public Project getProject() {
    return project;
  }

  /**
   * Sets the {@link Project project} information used to create project.
   *
   * @param project the given {@link Project project} information to set.
   */
  public void setProject(Project project) {
    this.project = project;
  }

  /**
   * Sets the {@link Project project} information used to create project.
   *
   * @param project the given {@link Project project} information to set.
   * @return the current {@link CreateProjectRequest create project request}
   *         instance.
   */
  public CreateProjectRequest withProject(Project project) {
    this.setProject(project);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder(this.getClass().getName());

    builder.append("{").append("\n")
           .append("\tproject:").append("\n").append(project.toString()).append("\n")
           .append("}");

    return builder.toString();
  }
}
