package org.qas.qtest.api.services.project.model;

import org.qas.api.ApiServiceRequest;
import org.qas.qtest.api.internal.model.Field;
import org.qas.qtest.api.internal.model.ObjectType;

/**
 * CreateCustomFieldRequest
 *
 * @author Dzung Nguyen
 * @version $Id CreateCustomFieldRequest 2014-07-11 00:56:30z dungvnguyen $
 * @since 1.0
 */
public final class CreateCustomFieldRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private ObjectType objectType;
  private Field field;

  //~ class members ===========================================================

  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the project identifier and return current instance.
   *
   * @param projectId the given project identifier to set.
   * @return current {@link CreateCustomFieldRequest} instance.
   */
  public CreateCustomFieldRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the object type.
   */
  public ObjectType getObjectType() {
    return objectType;
  }

  /**
   * Sets the object type.
   *
   * @param objectType the given object type to set.
   */
  public void setObjectType(ObjectType objectType) {
    this.objectType = objectType;
  }

  /**
   * Sets the object type and return current instance.
   *
   * @param objectType the given object type to set.
   * @return current {@link CreateCustomFieldRequest} instance.
   */
  public CreateCustomFieldRequest withFieldType(ObjectType objectType) {
    setObjectType(objectType);
    return this;
  }

  /**
   * @return the field object.
   */
  public Field getField() {
    return field;
  }

  /**
   * Sets the field object.
   *
   * @param field the given field object to set.
   */
  public void setField(Field field) {
    this.field = field;
  }

  /**
   * Sets the field object.
   *
   * @param field the given field object to set.
   * @return current {@link CreateCustomFieldRequest} instance.
   */
  public CreateCustomFieldRequest withField(Field field) {
    setField(field);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("CreateCustomFieldRequest{\n");
    sb.append("\tprojectId: ").append(projectId).append(", \n");
    sb.append("\tobjectType: ").append(objectType).append(", \n");
    sb.append("\tfield: \n").append(field).append(", \n");
    sb.append('}');
    return sb.toString();
  }
}
