package org.qas.qtest.api.services.plan.model;

import org.qas.api.ApiServiceRequest;

/**
 * CreateReleaseRequest
 *
 * @author Dzung Nguyen
 * @version $Id CreateReleaseRequest 2014-07-18 13:37:30z dungvnguyen $
 * @since 1.0
 */
public class CreateReleaseRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private Release release;

  //~ class members ===========================================================
  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the given project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the given project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the current request instance.
   */
  public CreateReleaseRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the release instance.
   */
  public Release getRelease() {
    return release;
  }

  /**
   * Sets the release instance.
   *
   * @param release the given release instance to set.
   */
  public void setRelease(Release release) {
    this.release = release;
  }

  /**
   * Sets the release instance.
   *
   * @param release the given release instance to set.
   * @return the current request instance.
   */
  public CreateReleaseRequest withRelease(Release release) {
    setRelease(release);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("CreateReleaseRequest{\n");
    sb.append("\tprojectId: ").append(projectId).append(", \n");
    sb.append("\trelease: ").append(release).append("\n");
    sb.append('}');
    return sb.toString();
  }
}
