package org.qas.qtest.api.services.plan;

import org.qas.api.AuthServiceException;
import org.qas.qtest.api.internal.QTestService;
import org.qas.qtest.api.services.plan.model.Build;
import org.qas.qtest.api.services.plan.model.CreateBuildRequest;
import org.qas.qtest.api.services.plan.model.CreateReleaseRequest;
import org.qas.qtest.api.services.plan.model.Release;

/**
 * TestPlanService
 *
 * @author Dzung Nguyen
 * @version $Id TestPlanService 2014-07-18 11:29:30z dungvnguyen $
 * @since 1.0
 */
public interface TestPlanService extends QTestService {
  /**
   * Creates release from the {@link CreateReleaseRequest} .
   *
   * @param createReleaseRequest the given {@link CreateReleaseRequest create release request}
   * @return the {@link Release} instance.
   * @throws AuthServiceException if an error occurs during creating release.
   */
  Release createRelease(CreateReleaseRequest createReleaseRequest) throws AuthServiceException;

  /**
   * Creates build from the {@link CreateBuildRequest create build request}
   *
   * @param createBuildRequest the given {@link CreateBuildRequest create build request}
   * @return the {@link Build} instance.
   * @throws AuthServiceException if an error occurs during creating build.
   */
  Build createBuild(CreateBuildRequest createBuildRequest) throws AuthServiceException;
}
