package org.qas.qtest.api.services.link.model;

import org.qas.api.ApiServiceRequest;
import org.qas.qtest.api.internal.model.ObjectType;

import java.util.List;

/**
 * @author trongle
 * @version $Id 4/21/2017 2:51 PM
 */
public class CreateArtifactLinkRequest extends ApiServiceRequest {
  protected Long projectId;

  /**
   * Artifact type which another type reference to
   */
  protected ObjectType destObjectType;

  /**
   * Parent artifact id
   */
  protected Long destArtifactId;

  /**
   * Artifact type will be linked
   */
  protected ObjectType sourceObjectType;

  /**
   * Linked artifact id
   */
  protected List<Long> sourceArtifactIds;

  public Long getProjectId() {
    return projectId;
  }

  public CreateArtifactLinkRequest setProjectId(Long projectId) {
    this.projectId = projectId;
    return this;
  }

  public ObjectType getDestObjectType() {
    return destObjectType;
  }

  public CreateArtifactLinkRequest setDestObjectType(ObjectType destObjectType) {
    this.destObjectType = destObjectType;
    return this;
  }

  public Long getDestArtifactId() {
    return destArtifactId;
  }

  public CreateArtifactLinkRequest setDestArtifactId(Long destArtifactId) {
    this.destArtifactId = destArtifactId;
    return this;
  }

  public ObjectType getSourceObjectType() {
    return sourceObjectType;
  }

  public CreateArtifactLinkRequest setSourceObjectType(ObjectType sourceObjectType) {
    this.sourceObjectType = sourceObjectType;
    return this;
  }

  public List<Long> getSourceArtifactIds() {
    return sourceArtifactIds;
  }

  public CreateArtifactLinkRequest setSourceArtifactIds(List<Long> sourceArtifactIds) {
    this.sourceArtifactIds = sourceArtifactIds;
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("CreateArtifactLinkRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", destObjectType=").append(destObjectType);
    sb.append(", destArtifactId=").append(destArtifactId);
    sb.append(", sourceObjectType=").append(sourceObjectType);
    sb.append(", sourceArtifactIds=").append(sourceArtifactIds);
    sb.append('}');
    return sb.toString();
  }
}
