package org.qas.qtest.api.services.link;

import org.qas.qtest.api.internal.QTestService;
import org.qas.qtest.api.services.link.model.ArtifactLink;
import org.qas.qtest.api.services.link.model.CreateArtifactLinkRequest;
import org.qas.qtest.api.services.link.model.DeleteArtifactLinkRequest;
import org.qas.qtest.api.services.link.model.GetArtifactLinkRequest;

import java.util.List;

/**
 * SearchService
 *
 * @author trongle
 * @since 1.4.2
 */
public interface ArtifactLinkService extends QTestService {
  /**
   * Create link artifact
   *
   * @param in
   * @return
   */
  List<ArtifactLink> link(CreateArtifactLinkRequest in);

  /**
   * Delete link artifact
   *
   * @param in
   * @return
   */
  boolean unlink(DeleteArtifactLinkRequest in);

  /**
   * Find artifact by ids
   *
   * @param in
   * @return
   */
  List<ArtifactLink> find(GetArtifactLinkRequest in);
}
