package org.qas.qtest.api.services.host.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.host.model.PongMessage;

/**
 * PongMessageJsonUnmarshaller
 *
 * @author Thong Nguyen
 * @version $Id PongMessageJsonUnmarshaller 2015-03-19 11:28:30z thongnguyen $
 * @since 1.0
 */
public class PongMessageJsonUnmarshaller extends AbstractUnmarshaller<PongMessage, JsonUnmarshallerContext> {
  //~ class instance ==========================================================
  private static PongMessageJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static PongMessageJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new PongMessageJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public PongMessage parse(String data) throws Exception {
    return JsonMapper.parseJson(data, PongMessage.class);
  }
}
