package org.qas.qtest.api.services.host.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.host.model.DeleteAutomationAgentRequest;

/**
 * DeleteAutomationAgentRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id DeleteAutomationAgentRequestMarshaller 2015-03-25 11:23:30z dzungvnguyen $
 * @since 1.0
 */
public class DeleteAutomationAgentRequestMarshaller extends AbstractMarshaller<Request, DeleteAutomationAgentRequest> {

  @Override
  protected void validateRequest(DeleteAutomationAgentRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to marshall(...)");
    }

    if (in.getHostServerId() == null) {
      throw new AuthClientException("Invalid project instance passed to marshall(...)");
    }

    if (in.getAgentServerId() == null || in.getHostServerId() == null) {
      throw new AuthClientException("Invalid automation agent instance passed to marshall(...)");
    }
  }

  @Override
  protected void build(Request request, DeleteAutomationAgentRequest in) {
    request.setHttpMethod(HttpMethod.DELETE);
  }

  @Override
  protected String getServiceName() {
    return "HostService";
  }

  @Override
  protected String getActionName() {
    return "DeleteAgent";
  }

  @Override
  protected String getContent(DeleteAutomationAgentRequest in) throws Exception {
    return null;
  }

  @Override
  protected StringBuilder getResourcePath(DeleteAutomationAgentRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId())
      .append("/automation/hosts/")
      .append(in.getHostServerId())
      .append("/agents/")
      .append(in.getAgentServerId());
  }
}
