package org.qas.qtest.api.services.host.model;

import org.qas.api.ApiServiceRequest;

/**
 * UpdateJobStatusRequest
 *
 * @author Thong Nguyen
 * @version $Id UpdateJobStatusRequest 2015-03-23 17:08:30z thongnguyen $
 * @since 1.0
 */
public class UpdateJobStatusRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private Long jobServerId;
  private Status status;
  private String agentLog = "";
  private String consoleLog = "";

  //~ class members ===========================================================
  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the current update status request.
   */
  public UpdateJobStatusRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the job server identifier.
   */
  public Long getJobServerId() {
    return jobServerId;
  }

  /**
   * Sets the job server identifier.
   *
   * @param jobServerId the given job identifier to set.
   */
  public void setJobServerId(Long jobServerId) {
    this.jobServerId = jobServerId;
  }

  /**
   * Sets the job server identifier.
   *
   * @param jobServerId the given job identifier to set.
   * @return the update job status request instance.
   */
  public UpdateJobStatusRequest withJobServerId(Long jobServerId) {
    setJobServerId(jobServerId);
    return this;
  }

  /**
   * @return the job status.
   */
  public Status getStatus() {
    return status;
  }

  /**
   * Sets the job status.
   *
   * @param status the given job status to set.
   */
  public void setStatus(Status status) {
    this.status = status;
  }

  /**
   * Sets the job status.
   *
   * @param status the given job status to set.
   * @return the update job status request instance.
   */
  public UpdateJobStatusRequest withStatus(Status status) {
    setStatus(status);
    return this;
  }

  public String getAgentLog() {
    return agentLog;
  }

  public void setAgentLog(String agentLog) {
    this.agentLog = agentLog;
  }

  public UpdateJobStatusRequest withAgentLog(String agentLog) {
    this.setAgentLog(agentLog);
    return this;
  }

  public String getConsoleLog() {
    return consoleLog;
  }

  public void setConsoleLog(String consoleLog) {
    this.consoleLog = consoleLog;
  }

  public UpdateJobStatusRequest withConsoleLog(String consoleLog) {
    this.setConsoleLog(consoleLog);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("UpdateJobStatusRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", jobServerId=").append(jobServerId);
    sb.append(", status=").append(status);
    sb.append(", agentLog=").append(agentLog);
    sb.append(", consoleLog=").append(consoleLog);
    sb.append('}');
    return sb.toString();
  }
}
