package org.qas.qtest.api.services.host.model;

import org.qas.api.ApiServiceRequest;

/**
 * DeleteAutomationAgentRequest
 *
 * @author Thong Nguyen
 * @version $Id DeleteAutomationAgentRequest 2015-03-25 11:17:30z dzungvnguyen $
 * @since 1.0
 */
public class DeleteAutomationAgentRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private Long hostServerId;
  private Long agentServerId;
  //~ class members ===========================================================
  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return current instance
   */
  public DeleteAutomationAgentRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return agent server identifier.
   */
  public Long getAgentServerId() {
    return agentServerId;
  }

  /**
   * Sets the agent server identifier.
   *
   * @param agentServerId the given agent server identifier.
   */
  public void setAgentServerId(Long agentServerId) {
    this.agentServerId = agentServerId;
  }

  /**
   * Sets the agent server identifier.
   *
   * @param agentServerId the given agent server identifier.
   * @return current instance.
   */
  public DeleteAutomationAgentRequest withAgentServerId(Long agentServerId) {
    setAgentServerId(agentServerId);
    return this;
  }

  /**
   * @return the host server identifier.
   */
  public Long getHostServerId() {
    return hostServerId;
  }

  /**
   * Sets the host server identifier.
   *
   * @param hostServerId the given host server identifier to set.
   */
  public void setHostServerId(Long hostServerId) {
    this.hostServerId = hostServerId;
  }

  /**
   * Sets the host server identifier.
   *
   * @param hostServerId the given host server identifier to set.
   * @return current instance.
   */
  public DeleteAutomationAgentRequest withHostServerId(Long hostServerId) {
    setHostServerId(hostServerId);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("DeleteAutomationAgentRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", hostServerId=").append(hostServerId);
    sb.append(", agentServerId=").append(agentServerId);
    sb.append('}');
    return sb.toString();
  }
}
