package org.qas.qtest.api.services.host.model;

import org.qas.api.ApiServiceRequest;

/**
 * CreateAutomationHostRequest
 *
 * @author Thong Nguyen
 * @version $Id CreateAutomationHostRequest 2015-03-14 22:17:30z thongnguyen $
 * @since 1.0
 */
public class CreateAutomationHostRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private AutomationHost automationHost;

  //~ class members ===========================================================
  /**
   * Creates {@link CreateAutomationHostRequest create automation host request}
   * instance.
   */
  public CreateAutomationHostRequest() {}

  /**
   * Creates {@link CreateAutomationHostRequest create automation host request}
   * instance from the given automation host instance.
   *
   * @param automationHost the given automation host instance.
   */
  public CreateAutomationHostRequest(AutomationHost automationHost) {
    this.automationHost = automationHost;
  }

  /**
   * @return the automation host instance.
   */
  public AutomationHost getAutomationHost() {
    return automationHost;
  }

  /**
   * Sets the automation host instance.
   *
   * @param automationHost the given automation host instance to set.
   */
  public void setAutomationHost(AutomationHost automationHost) {
    this.automationHost = automationHost;
  }

  /**
   * Sets the automation host instance.
   *
   * @param automationHost the given automation host instance to set.
   * @return the current instance.
   */
  public CreateAutomationHostRequest withAutomationHost(AutomationHost automationHost) {
    setAutomationHost(automationHost);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("CreateAutomationHostRequest{\n");
    sb.append("\thost: ").append(automationHost).append(", \n");
    sb.append('}');
    return sb.toString();
  }
}
