package org.qas.qtest.api.services.host.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.qas.qtest.api.internal.model.QTestBaseModel;

/**
 * AutomationAgent
 *
 * @author Thong Nguyen
 * @version $Id AutomationAgent 2015-03-14 21:48:30z thongnguyen $
 * @since 1.0
 */
public class AutomationAgent extends QTestBaseModel<AutomationAgent> {

  @JsonProperty("agent_server_id")
  private Long agentServerId;

  @JsonProperty("name")
  private String name;

  @JsonProperty("framework")
  private String framework;

  @JsonProperty("framework_id")
  private String frameworkId;

  @JsonProperty("project_id")
  private Long projectId;

  @JsonProperty("host_id")
  private Long hostId;

  @JsonProperty("active")
  private Boolean active;

  @JsonProperty("agent_id")
  private Long agentId;

  @JsonProperty("configuration")
  private String configuration;

  public AutomationAgent() {
  }

  /**
   * @return the server agent identifier.
   */
  public Long getAgentServerId() {
    return agentServerId;
  }

  /**
   * Sets the server agent identifier.
   *
   * @param qTestAgentId the given agent identifier obtain from server.
   * @return current instance.
   */
  public AutomationAgent setAgentServerId(Long qTestAgentId) {
    this.agentServerId = qTestAgentId;
    return this;
  }

  /**
   * Sets the server agent identifier.
   *
   * @param qTestAgentId the given agent identifier obtain from server.
   * @return the current instance.
   */
  public AutomationAgent withAgentServerId(Long qTestAgentId) {
    setAgentServerId(qTestAgentId);
    return this;
  }

  /**
   * @return the agent name.
   */
  public String getName() {
    return name;
  }

  /**
   * Sets the agent name.
   *
   * @param name the agent name to set.
   * @return current instance.
   */
  public AutomationAgent setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Sets the agent name.
   *
   * @param name the given agent name to set.
   * @return the {@link AutomationAgent} instance.
   */
  public AutomationAgent withName(String name) {
    setName(name);
    return this;
  }

  /**
   * t
   *
   * @return the automation host framework.
   */
  public String getFramework() {
    return framework;
  }

  /**
   * Sets the automation agent framework.
   *
   * @param framework the given automation agent framework.
   * @return current instance.
   */
  public AutomationAgent setFramework(String framework) {
    this.framework = framework;
    return this;
  }

  /**
   * Sets the framework.
   *
   * @param framework the given automation agent framework.
   * @return the current instance.
   */
  public AutomationAgent withFramework(String framework) {
    setFramework(framework);
    return this;
  }

  /**
   * @return the automation host framework id.
   */
  public String getFrameworkId() {
    return frameworkId;
  }

  /**
   * Sets the automation agent framework id.
   *
   * @param frameworkId the given automation agent framework.
   * @return current instance.
   */
  public AutomationAgent setFrameworkId(String frameworkId) {
    this.frameworkId = frameworkId;
    return this;
  }

  /**
   * Sets the framework id.
   *
   * @param frameworkId the given automation agent framework.
   * @return the current instance.
   */
  public AutomationAgent withFrameworkId(String frameworkId) {
    setFrameworkId(frameworkId);
    return this;
  }

  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return current instance.
   */
  public AutomationAgent setProjectId(Long projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the current instance.
   */
  public AutomationAgent withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the host identifier.
   */
  public Long getHostId() {
    return hostId;
  }

  /**
   * Sets the host identifier.
   *
   * @param hostId the given host identifier to set.
   * @return current instance.
   */
  public AutomationAgent setHostId(Long hostId) {
    this.hostId = hostId;
    return this;
  }

  /**
   * Sets the host identifier.
   *
   * @param hostId the given host identifier to set.
   * @return the current instance.
   */
  public AutomationAgent withHostId(Long hostId) {
    setHostId(hostId);
    return this;
  }

  /**
   * @return {@code true} if the agent is active.
   */
  public Boolean isActive() {
    return active;
  }

  /**
   * Sets the agent action.
   *
   * @param active the given active flag.
   * @return current instance.
   */
  public AutomationAgent setActive(Boolean active) {
    this.active = active;
    return this;
  }

  /**
   * Sets the agent action.
   *
   * @param active the given active flag to set.
   * @return the current instance.
   */
  public AutomationAgent withActive(Boolean active) {
    setActive(active);
    return this;
  }

  /**
   * @return the agent client identifier.
   */
  public Long getAgentId() {
    return agentId;
  }

  /**
   * Sets the agent client identifier.
   *
   * @param agentId the given agent client identifier.
   * @return current instance.
   */
  public AutomationAgent setAgentId(Long agentId) {
    this.agentId = agentId;
    return this;
  }

  /**
   * Sets the client agent identifier.
   *
   * @param agentId the given agent client identifier.
   * @return the current instance.
   */
  public AutomationAgent withAgentId(Long agentId) {
    setAgentId(agentId);
    return this;
  }

  public String getConfiguration() {
    return configuration;
  }

  public void setConfiguration(String configuration) {
    this.configuration = configuration;
  }

  public AutomationAgent withConfiguration(String configuration) {
    setConfiguration(configuration);
    return this;
  }

  @Override
  public String elementName() {
    return "agent";
  }

  @Override
  public String jsonElementName() {
    return "agent";
  }

  @Override
  protected AutomationAgent clone() {
    AutomationAgent copy = new AutomationAgent();
    copy.setPropertiesFrom(this);
    return copy;
  }
}
