package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.JsonModel;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.services.execution.model.UpdateTestSuiteRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * UpdateTestSuiteRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id UpdateTestSuiteRequestMarshaller 2015-05-29 17:24:30z dzungvnguyen $
 * @since 1.0
 */
public final class UpdateTestSuiteRequestMarshaller
  extends AbstractTestSuiteRequestMarshaller<UpdateTestSuiteRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(UpdateTestSuiteRequest testSuiteRequest) throws Exception {
    // validate input.
    testSuiteRequest = ApiPreconditions.notNull(testSuiteRequest);
    validateProjectId(testSuiteRequest.getProjectId());
    ApiPreconditions.notNull(testSuiteRequest.getTestSuite(), "Invalid test-suite data passed to marshall(...)");

    // resolve test cycle identifier.
    Long testSuiteId = (testSuiteRequest.getTestSuiteId() != null
      ? testSuiteRequest.getTestSuiteId()
      : testSuiteRequest.getTestSuite().getId()
    );
    validateTestSuiteId(testSuiteId);

    // normalize the test-cycle identifier.
    testSuiteRequest.getTestSuite().setId(testSuiteId);

    // create update request.
    Request request = createJsonRequest(testSuiteRequest, "UpdateTestSuite", HttpMethod.PUT);

    // set resource path.
    StringBuilder builder = createApiPathBuilder(testSuiteRequest.getProjectId());
    builder.append('/').append(testSuiteId.longValue());
    request.setResourcePath(builder.toString());

    // set resource content.
    request.setContent(new StringInputStream(JsonMapper.toJson(testSuiteRequest.getTestSuite())));
    return request;
  }
}
