package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.services.execution.model.DeleteTestSuiteRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * DeleteTestSuiteRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id DeleteTestSuiteRequestMarshaller 2015-05-29 16:53:30z dzungvnguyen $
 * @since 1.0
 */
public final class DeleteTestSuiteRequestMarshaller
  extends AbstractTestSuiteRequestMarshaller<DeleteTestSuiteRequest>{
  //~ class members ===========================================================
  @Override
  public Request marshall(DeleteTestSuiteRequest testSuiteRequest) throws Exception {
    // validate parameters.
    testSuiteRequest = ApiPreconditions.notNull(testSuiteRequest);
    validateProjectId(testSuiteRequest.getProjectId());
    validateTestSuiteId(testSuiteRequest.getTestSuiteId());

    // create request.
    Request request = createJsonRequest(testSuiteRequest, "DeleteTestSuite", HttpMethod.DELETE);

    // create resource path.
    StringBuilder pathBuilder = createApiPathBuilder(testSuiteRequest.getProjectId());
    pathBuilder.append('/').append(testSuiteRequest.getTestSuiteId());
    request.setResourcePath(pathBuilder.toString());

    return request;
  }
}
