package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.services.execution.model.DeleteTestCycleRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * DeleteTestCycleRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id DeleteTestCycleRequestMarshaller 2015-05-29 15:14:30z dzungvnguyen $
 * @since 1.0
 */
public final class DeleteTestCycleRequestMarshaller
  extends AbstractTestCycleRequestMarshaller<DeleteTestCycleRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(DeleteTestCycleRequest testCycleRequest) throws Exception {
    testCycleRequest = ApiPreconditions.notNull(testCycleRequest);
    validateProjectId(testCycleRequest.getProjectId());
    validateTestCycleId(testCycleRequest.getTestCycleId());

    // create request.
    Request request = createJsonRequest(testCycleRequest, "DeleteTestCycle", HttpMethod.DELETE);

    // build request parameter.
    if (testCycleRequest.isForce()) {
      request.addParameter("force", "true");
    }

    StringBuilder pathBuilder  = createApiPathBuilder(testCycleRequest.getProjectId());
    pathBuilder.append('/').append(testCycleRequest.getTestCycleId());
    request.setResourcePath(pathBuilder.toString());

    return request;
  }
}
