package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.services.execution.model.CreateTestSuiteRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * CreateTestSuiteRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id CreateTestSuiteRequestMarshaller 2015-05-29 17:10:30z dzungvnguyen $
 * @since 1.0
 */
public final class CreateTestSuiteRequestMarshaller
  extends AbstractTestSuiteRequestMarshaller<CreateTestSuiteRequest> {
  // class members ============================================================
  @Override
  public Request marshall(CreateTestSuiteRequest testSuiteRequest) throws Exception {
    // validate request.
    testSuiteRequest = ApiPreconditions.notNull(testSuiteRequest);
    validateProjectId(testSuiteRequest.getProjectId());
    ApiPreconditions.notNull(testSuiteRequest.getTestSuite(), "Invalid test-suite passed to marshall(...)");
    validateArtifactLevel(testSuiteRequest.getArtifactLevel());
    validateArtifact(testSuiteRequest.getArtifactLevel(), testSuiteRequest.getArtifactId());

    // create request.
    Request request = createJsonRequest(testSuiteRequest, "CreateTestSuite", HttpMethod.POST);

    // set resource path.
    request.setResourcePath(createApiPathBuilder(testSuiteRequest.getProjectId()).toString());

    // set request parameter.
    if (testSuiteRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
      request.addParameter("parentId", String.valueOf(testSuiteRequest.getArtifactId()));
      request.addParameter("parentType", testSuiteRequest.getArtifactLevel().getQueryParam());
    }

    // set body content.
    request.setContent(new StringInputStream(JsonMapper.toJson(testSuiteRequest.getTestSuite())));
    return request;
  }
}
