package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.ApiServiceRequest;
import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.internal.model.transform.AbstractQTestApiRequestMarshaller;

import java.util.Set;

import static org.qas.qtest.api.internal.util.ApiPreconditions.checkArgument;

/**
 * AbstractTestExecutionRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id AbstractTestExecutionRequestMarshaller 2015-05-29 16:04:30z dzungvnguyen $
 * @since 1.0
 */
public abstract class AbstractTestExecutionRequestMarshaller<T extends ApiServiceRequest>
  extends AbstractQTestApiRequestMarshaller<T> {
  //~ class properties ========================================================
  /**
   * Validate artifact level value.
   *
   * @param artifactLevel the given artifact level value to validate.
   * @param allowLevels the given the set of allow levels.
   * @throws AuthClientException if an error occurs during validating artifact type.
   */
  static void validateArtifactLevel(ArtifactLevel artifactLevel,
                                    Set<ArtifactLevel> allowLevels) throws AuthClientException {
    checkArgument(
      artifactLevel != null && allowLevels.contains(artifactLevel),
      "Invalid artifact type passed to marshall(...)"
    );
  }

  /**
   * Validate artifact.
   *
   * @param artifactLevel the given artifact level.
   * @param artifactId the given artifact identifier.
   * @throws AuthClientException if an error occurs during validating artifact.
   */
  static void validateArtifact(ArtifactLevel artifactLevel, Long artifactId) throws AuthClientException {
    boolean valid = (artifactLevel == ArtifactLevel.ROOT
      ? (artifactId == null || artifactId == 0L)
      : (artifactId != null && artifactId > 0L));
    checkArgument(valid, "Invalid artifact id passed to marshall(...)");
  }

  /**
   * Creates json request from the given request type, request action and request method.
   *
   * @param requestType the given request type.
   * @param requestAction the given request action.
   * @param requestMethod the given request method.
   * @return the request instance.
   */
  protected Request createJsonRequest(T requestType, String requestAction, HttpMethod requestMethod) {
    return createJsonRequest(requestType, "TestExecutionService", requestAction, requestMethod);
  }

  /**
   * @return the based request from the given project identifier.
   */
  protected StringBuilder createApiPathBuilder(Long projectId) {
    StringBuilder pathBuilder = new StringBuilder(createApiBasePathWithProject(projectId));
    pathBuilder.append("/").append(getArtifactPath());
    return pathBuilder;
  }

  /**
   * @return the artifact value.
   */
  protected abstract String getArtifactPath();
}