package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * UpdateTestCycleRequest
 *
 * @author Dzung Nguyen
 * @version $Id UpdateTestCycleRequest 2015-05-29 06:57:30z dzungvnguyen $
 * @since 1.0
 */
public class UpdateTestCycleRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  protected Long testCycleId;
  protected TestCycle testCycle;

  //~ class members ===========================================================
  /**
   * Sets project id.
   *
   * @param projectId the given project identifier to set.
   * @return the current update test-cycle request.
   */
  public UpdateTestCycleRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test-cycle identifier.
   */
  public Long getTestCycleId() {
    return testCycleId;
  }

  /**
   * Sets the test-cycle identifier.
   *
   * @param testCycleId the given test-cycle identifier to set.
   */
  public void setTestCycleId(Long testCycleId) {
    this.testCycleId = testCycleId;
  }

  /**
   * Sets the test-cycle identifier.
   *
   * @param testCycleId the given test-cycle identifier.
   * @return current update test-cycle request.
   */
  public UpdateTestCycleRequest withTestCycleId(Long testCycleId) {
    setTestCycleId(testCycleId);
    return this;
  }

  /**
   * @return the test cycle.
   */
  public TestCycle getTestCycle() {
    return testCycle;
  }

  /**
   * Sets the test-cycle.
   *
   * @param testCycle the given test-cycle instance.
   */
  public void setTestCycle(TestCycle testCycle) {
    this.testCycle = testCycle;
  }

  /**
   * Sets the test-cycle instance.
   *
   * @param testCycle the given test-cycle instance to set.
   * @return the update test cycle request instance.
   */
  public UpdateTestCycleRequest withTestCycle(TestCycle testCycle) {
    setTestCycle(testCycle);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("UpdateTestCycleRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", testCycleId=").append(testCycleId);
    sb.append(", testCycle=").append(testCycle);
    sb.append('}');
    return sb.toString();
  }
}
