package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.ArtifactLevel;

/**
 * MoveTestCycleRequest
 *
 * @author Dzung Nguyen
 * @version $Id MoveTestCycleRequest 2015-05-29 07:31:30z dzungvnguyen $
 * @since 1.0
 */
public class MoveTestCycleRequest extends UpdateTestCycleRequest {
  //~ class properties ========================================================
  private ArtifactLevel artifactLevel = ArtifactLevel.ROOT;
  private Long artifactId = 0L;

  //~ class members ===========================================================
  /**
   * Sets project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the current move test-cycle request instance.
   */
  public MoveTestCycleRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * Sets the test-cycle identifier.
   *
   * @param testCycleId the given test-cycle identifier.
   * @return the current move test-cycle request instance.
   */
  public MoveTestCycleRequest withTestCycleId(Long testCycleId) {
    setTestCycleId(testCycleId);
    return this;
  }

  /**
   * Sets the test-cycle instance.
   *
   * @param testCycle the given test-cycle instance to set.
   * @return the current move test-cycle request instance.
   */
  public MoveTestCycleRequest withTestCycle(TestCycle testCycle) {
    setTestCycle(testCycle);
    return this;
  }

  /**
   * @return the given artifact identifier.
   */
  public Long getArtifactId() {
    return artifactId;
  }

  /**
   * Sets the artifact identifier.
   *
   * @param artifactId the given artifact identifier to set.
   */
  public void setArtifactId(Long artifactId) {
    this.artifactId = artifactId;
  }

  /**
   * Sets the artifact identifier.
   *
   * @param artifactId the given artifact identifier to set.
   * @return current move test cycle request instance.
   */
  public MoveTestCycleRequest withArtifactId(Long artifactId) {
    setArtifactId(artifactId);
    return this;
  }

  /**
   * @return the artifact level value.
   */
  public ArtifactLevel getArtifactLevel() {
    return artifactLevel;
  }

  /**
   * Sets the artifact level value.
   *
   * @param artifactLevel the given artifact level value.
   */
  public void setArtifactLevel(ArtifactLevel artifactLevel) {
    this.artifactLevel = artifactLevel;
  }

  /**
   * Sets artifact level value.
   *
   * @param artifactLevel the given artifact level value.
   * @return the move test cycle request.
   */
  public MoveTestCycleRequest withArtifactLevel(ArtifactLevel artifactLevel) {
    setArtifactLevel(artifactLevel);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("MoveTestCycleRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", artifactId=").append(artifactId);
    sb.append(", artifactLevel=").append(artifactLevel);
    sb.append(", testCycleId=").append(testCycleId);
    sb.append(", testCycle=").append(testCycle);
    sb.append('}');
    return sb.toString();
  }
}
